/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect.step;

import dev.jsinco.brewery.bukkit.util.BukkitAdapter;
import dev.jsinco.brewery.event.EventPropertyExecutable;
import dev.jsinco.brewery.event.EventStep;
import dev.jsinco.brewery.vector.BreweryLocation;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;

public class TeleportExecutable
implements EventPropertyExecutable {
    private final BreweryLocation.Uncompiled location;

    public TeleportExecutable(BreweryLocation.Uncompiled location) {
        this.location = location;
    }

    @Override
    @NotNull
    public EventPropertyExecutable.ExecutionResult execute(UUID contextPlayer, List<? extends EventStep> events, int index) {
        Player player = Bukkit.getPlayer((UUID)contextPlayer);
        if (player == null) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        List<UUID> worldUuids = Bukkit.getWorlds().stream().map(WorldInfo::getUID).toList();
        BreweryLocation breweryLocation = this.location.get(worldUuids);
        if (breweryLocation == null) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        player.teleportAsync(BukkitAdapter.toLocation(breweryLocation));
        return EventPropertyExecutable.ExecutionResult.CONTINUE;
    }

    @Override
    public int priority() {
        return 0;
    }
}

