/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.ingredient;

import dev.jsinco.brewery.bukkit.ingredient.BreweryIngredient;
import dev.jsinco.brewery.ingredient.Ingredient;
import dev.jsinco.brewery.ingredient.ScoredIngredient;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.MessageUtil;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

public class ScoredBreweryIngredient
implements ScoredIngredient {
    private final double score;
    private final BreweryKey ingredientKey;
    private final String displayName;

    public ScoredBreweryIngredient(BreweryKey ingredientKey, double score, String displayName) {
        this.ingredientKey = ingredientKey;
        this.score = score;
        this.displayName = displayName;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.ingredientKey.toString();
    }

    @Override
    @NotNull
    public Component displayName() {
        return MessageUtil.miniMessage(this.displayName, new TagResolver[0]).append((Component)Component.text((String)"-")).append((Component)Component.text((double)this.score));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScoredBreweryIngredient that = (ScoredBreweryIngredient)o;
        return Objects.equals(this.ingredientKey, that.ingredientKey) && Objects.equals(this.score, that.score);
    }

    public int hashCode() {
        return Objects.hash(this.ingredientKey, this.score);
    }

    @Override
    public double score() {
        return this.score;
    }

    @Override
    public Ingredient baseIngredient() {
        return new BreweryIngredient(this.ingredientKey, this.displayName);
    }
}

