/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration;

import dev.jsinco.brewery.bukkit.integration.Integration;
import dev.jsinco.brewery.bukkit.integration.IntegrationRegistry;
import dev.jsinco.brewery.bukkit.integration.IntegrationType;
import dev.jsinco.brewery.bukkit.integration.item.CraftEngineIntegration;
import dev.jsinco.brewery.bukkit.integration.item.ItemsAdderIntegration;
import dev.jsinco.brewery.bukkit.integration.item.MmoItemsIntegration;
import dev.jsinco.brewery.bukkit.integration.item.NexoIntegration;
import dev.jsinco.brewery.bukkit.integration.item.OraxenIntegration;
import dev.jsinco.brewery.bukkit.integration.placeholder.MiniPlaceholdersIntegration;
import dev.jsinco.brewery.bukkit.integration.placeholder.PlaceholderApiIntegration;
import dev.jsinco.brewery.bukkit.integration.structure.BoltIntegration;
import dev.jsinco.brewery.bukkit.integration.structure.GriefPreventionIntegration;
import dev.jsinco.brewery.bukkit.integration.structure.HuskClaimsIntegration;
import dev.jsinco.brewery.bukkit.integration.structure.LandsIntegration;
import dev.jsinco.brewery.bukkit.integration.structure.TownyIntegration;
import dev.jsinco.brewery.bukkit.integration.structure.WorldGuardIntegration;
import dev.jsinco.brewery.util.Logger;
import java.util.Set;
import lombok.Generated;

public class IntegrationManager {
    private final IntegrationRegistry integrationRegistry = new IntegrationRegistry();

    public void init() {
        this.register(IntegrationType.STRUCTURE, new WorldGuardIntegration());
        this.register(IntegrationType.STRUCTURE, new BoltIntegration());
        this.register(IntegrationType.STRUCTURE, new GriefPreventionIntegration());
        this.register(IntegrationType.STRUCTURE, new HuskClaimsIntegration());
        this.register(IntegrationType.STRUCTURE, new LandsIntegration());
        this.register(IntegrationType.STRUCTURE, new TownyIntegration());
        this.register(IntegrationType.ITEM, new CraftEngineIntegration());
        this.register(IntegrationType.ITEM, new ItemsAdderIntegration());
        this.register(IntegrationType.ITEM, new NexoIntegration());
        this.register(IntegrationType.ITEM, new OraxenIntegration());
        this.register(IntegrationType.ITEM, new MmoItemsIntegration());
        this.register(IntegrationType.PLACEHOLDER, new PlaceholderApiIntegration());
        this.register(IntegrationType.PLACEHOLDER, new MiniPlaceholdersIntegration());
        this.integrationRegistry.getIntegrations(IntegrationType.ITEM).forEach(Integration::initialize);
        this.integrationRegistry.getIntegrations(IntegrationType.STRUCTURE).forEach(Integration::initialize);
        this.integrationRegistry.getIntegrations(IntegrationType.PLACEHOLDER).forEach(Integration::initialize);
    }

    public void register(IntegrationType<?> type, Integration integration) {
        if (!integration.enabled()) {
            return;
        }
        Logger.log("Registering integration " + integration.getId() + " with type " + String.valueOf(type));
        this.integrationRegistry.register(type, integration);
    }

    public void clear() {
        this.integrationRegistry.clear();
    }

    public <T extends Integration> Set<T> retrieve(IntegrationType<T> type) {
        Set<T> integrations = this.integrationRegistry.getIntegrations(type);
        if (integrations.isEmpty()) {
            return Set.of();
        }
        return integrations;
    }

    @Generated
    public IntegrationRegistry getIntegrationRegistry() {
        return this.integrationRegistry;
    }
}

