/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.recipe;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffect;
import dev.jsinco.brewery.bukkit.util.BukkitAdapter;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import dev.jsinco.brewery.bukkit.util.ListPersistentDataType;
import dev.jsinco.brewery.configuration.locale.TranslationsConfig;
import dev.jsinco.brewery.effect.DrunksManager;
import dev.jsinco.brewery.effect.DrunksManagerImpl;
import dev.jsinco.brewery.event.CustomEventRegistry;
import dev.jsinco.brewery.event.DrunkEvent;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.MessageUtil;
import dev.jsinco.brewery.util.Registry;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.PotionContents;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeEffects {
    public static final NamespacedKey COMMANDS = BukkitAdapter.toNamespacedKey(BreweryKey.parse("commands"));
    public static final NamespacedKey MESSAGE = BukkitAdapter.toNamespacedKey(BreweryKey.parse("message"));
    public static final NamespacedKey ACTION_BAR = BukkitAdapter.toNamespacedKey(BreweryKey.parse("action_bar"));
    public static final NamespacedKey TITLE = BukkitAdapter.toNamespacedKey(BreweryKey.parse("titles"));
    public static final NamespacedKey ALCOHOL = BukkitAdapter.toNamespacedKey(BreweryKey.parse("alcohol"));
    public static final NamespacedKey TOXINS = BukkitAdapter.toNamespacedKey(BreweryKey.parse("toxins"));
    public static final NamespacedKey EVENTS = BukkitAdapter.toNamespacedKey(BreweryKey.parse("events"));
    private static final List<NamespacedKey> PDC_TYPES = List.of(COMMANDS, MESSAGE, ACTION_BAR, TITLE, ALCOHOL, TOXINS, EVENTS);
    public static final RecipeEffects GENERIC = new Builder().effects(List.of()).build();
    @NotNull
    private final @NotNull List<@NotNull RecipeEffect> effects;
    @Nullable
    private final String title;
    @Nullable
    private final String message;
    @Nullable
    private final String actionBar;
    private final int alcohol;
    @NotNull
    private final @NotNull List<@NotNull BreweryKey> events;
    private final int toxins;

    private RecipeEffects(@NotNull List<RecipeEffect> effects, @Nullable String title, @Nullable String message, @Nullable String actionBar, int alcohol, @NotNull @NotNull List<@NotNull BreweryKey> events, int toxins) {
        this.effects = effects;
        this.title = title;
        this.message = message;
        this.actionBar = actionBar;
        this.alcohol = alcohol;
        this.events = events;
        this.toxins = toxins;
    }

    public List<DrunkEvent> getEvents() {
        CustomEventRegistry customEventRegistry = TheBrewingProject.getInstance().getCustomDrunkEventRegistry();
        return this.events.stream().map(eventKey -> {
            if (Registry.DRUNK_EVENT.containsKey((BreweryKey)eventKey)) {
                return Registry.DRUNK_EVENT.get((BreweryKey)eventKey);
            }
            return customEventRegistry.getCustomEvent((BreweryKey)eventKey);
        }).filter(Objects::nonNull).toList();
    }

    public void applyTo(ItemStack itemStack) {
        itemStack.setData(DataComponentTypes.POTION_CONTENTS, (Object)((PotionContents)PotionContents.potionContents().addCustomEffects(this.effects.stream().map(RecipeEffect::newPotionEffect).toList()).build()));
        itemStack.editPersistentDataContainer(this::applyTo);
    }

    private void applyTo(PersistentDataContainer container) {
        PDC_TYPES.forEach(arg_0 -> ((PersistentDataContainer)container).remove(arg_0));
        if (this.title != null) {
            container.set(TITLE, PersistentDataType.STRING, (Object)this.title);
        }
        if (this.message != null) {
            container.set(MESSAGE, PersistentDataType.STRING, (Object)this.message);
        }
        if (this.actionBar != null) {
            container.set(ACTION_BAR, PersistentDataType.STRING, (Object)this.actionBar);
        }
        container.set(ALCOHOL, PersistentDataType.INTEGER, (Object)this.alcohol);
        container.set(TOXINS, PersistentDataType.INTEGER, (Object)this.toxins);
        container.set(EVENTS, ListPersistentDataType.STRING_LIST, this.events.stream().map(BreweryKey::toString).toList());
    }

    public static Optional<RecipeEffects> fromEntity(Entity entity) {
        return RecipeEffects.fromPdc((PersistentDataContainerView)entity.getPersistentDataContainer());
    }

    private static Optional<RecipeEffects> fromPdc(PersistentDataContainerView persistentDataContainer) {
        if (!persistentDataContainer.has(ALCOHOL)) {
            return Optional.empty();
        }
        Builder builder = new Builder();
        builder.alcohol((Integer)persistentDataContainer.getOrDefault(ALCOHOL, PersistentDataType.INTEGER, (Object)0));
        builder.toxins((Integer)persistentDataContainer.getOrDefault(TOXINS, PersistentDataType.INTEGER, (Object)0));
        if (persistentDataContainer.has(TITLE)) {
            builder.title((String)persistentDataContainer.get(TITLE, PersistentDataType.STRING));
        }
        if (persistentDataContainer.has(MESSAGE)) {
            builder.message((String)persistentDataContainer.get(MESSAGE, PersistentDataType.STRING));
        }
        if (persistentDataContainer.has(ACTION_BAR)) {
            builder.actionBar((String)persistentDataContainer.get(ACTION_BAR, PersistentDataType.STRING));
        }
        builder.events(((List)persistentDataContainer.getOrDefault(EVENTS, ListPersistentDataType.STRING_LIST, List.of())).stream().map(BreweryKey::parse).collect(Collectors.toList()));
        return Optional.of(builder.build());
    }

    public static Optional<RecipeEffects> fromItem(@NotNull ItemStack item) {
        return RecipeEffects.fromPdc(item.getPersistentDataContainer());
    }

    public void applyTo(Player player) {
        DrunksManager drunksManager = TheBrewingProject.getInstance().getDrunksManager();
        ((DrunksManagerImpl)drunksManager).consume(player.getUniqueId(), this.alcohol, this.toxins);
        if (this.title != null) {
            player.showTitle(Title.title((Component)BukkitMessageUtil.compilePlayerMessage(this.title, player, drunksManager, this.alcohol), (Component)Component.empty()));
        }
        if (this.message != null) {
            player.sendMessage(BukkitMessageUtil.compilePlayerMessage(this.message, player, drunksManager, this.alcohol));
        }
        if (this.actionBar != null) {
            player.sendActionBar(BukkitMessageUtil.compilePlayerMessage(this.actionBar, player, drunksManager, this.alcohol));
        } else {
            player.sendActionBar(MessageUtil.miniMessage(TranslationsConfig.INFO_AFTER_DRINK, MessageUtil.getDrunkStateTagResolver(((DrunksManagerImpl)drunksManager).getDrunkState(player.getUniqueId()))));
        }
        this.getEvents().forEach(drunkEvent -> TheBrewingProject.getInstance().getDrunkEventExecutor().doDrunkEvent(player.getUniqueId(), (DrunkEvent)drunkEvent));
    }

    public void applyTo(Projectile projectile) {
        PersistentDataContainer persistentDataContainer = projectile.getPersistentDataContainer();
        this.applyTo(persistentDataContainer);
    }

    public RecipeEffects withToxins(RecipeEffects recipeEffects, int toxins) {
        return new RecipeEffects(recipeEffects.effects, recipeEffects.title, recipeEffects.message, recipeEffects.actionBar, recipeEffects.alcohol, recipeEffects.events, toxins);
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull RecipeEffect> getEffects() {
        return this.effects;
    }

    @Nullable
    @Generated
    public String getTitle() {
        return this.title;
    }

    @Nullable
    @Generated
    public String getMessage() {
        return this.message;
    }

    @Nullable
    @Generated
    public String getActionBar() {
        return this.actionBar;
    }

    @Generated
    public int getAlcohol() {
        return this.alcohol;
    }

    @Generated
    public int getToxins() {
        return this.toxins;
    }

    public static class Builder {
        private List<RecipeEffect> effects = List.of();
        @Nullable
        private String title;
        @Nullable
        private String message;
        @Nullable
        private String actionBar;
        @NotNull
        private @NotNull List<@NotNull BreweryKey> events = List.of();
        private int alcohol;
        private int toxins;

        public Builder effects(@NotNull @NotNull List<@NotNull RecipeEffect> effects) {
            this.effects = effects;
            return this;
        }

        public Builder events(@NotNull @NotNull List<@NotNull BreweryKey> events) {
            this.events = events;
            return this;
        }

        public Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        public Builder actionBar(@Nullable String actionBar) {
            this.actionBar = actionBar;
            return this;
        }

        public Builder alcohol(int alcohol) {
            this.alcohol = alcohol;
            return this;
        }

        public Builder toxins(int toxins) {
            this.toxins = toxins;
            return this;
        }

        public RecipeEffects build() {
            Preconditions.checkNotNull(this.effects);
            Preconditions.checkNotNull(this.events);
            return new RecipeEffects(this.effects, this.title, this.message, this.actionBar, this.alcohol, this.events, this.toxins);
        }
    }
}

