/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.structure;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.jsinco.brewery.bukkit.structure.BreweryStructure;
import dev.jsinco.brewery.bukkit.structure.StructureReadException;
import dev.jsinco.brewery.lib.dev.thorinwasher.schem.Schematic;
import dev.jsinco.brewery.lib.dev.thorinwasher.schem.SchematicReader;
import dev.jsinco.brewery.structure.StructureMeta;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.Pair;
import dev.jsinco.brewery.util.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.joml.Vector3i;

public class StructureReader {
    private static final Pattern SCHEM_PATTERN = Pattern.compile("\\.json", 2);
    private static final Pattern TAG_PATTERN = Pattern.compile("^#");
    private static final Pattern SCHEM_FILE_PATTERN = Pattern.compile("[a-zA-Z_0-9\\-]+");

    public static BreweryStructure fromInternalResourceJson(String string) throws IOException, StructureReadException {
        URI uri;
        URL url = Util.class.getResource(string);
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new StructureReadException(e);
        }
        try {
            return StructureReader.fromJson(Paths.get(uri));
        }
        catch (FileSystemNotFoundException e) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(uri, new HashMap());){
                BreweryStructure breweryStructure = StructureReader.fromJson(fileSystem.getPath(uri.toString().split("!")[1], new String[0]));
                return breweryStructure;
            }
        }
    }

    public static BreweryStructure fromJson(Path path) throws IOException, StructureReadException {
        try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));){
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String schemFileName = jsonObject.get("schem_file").getAsString();
            Optional<Vector3i> origin = Optional.ofNullable(jsonObject.get("origin")).map(JsonElement::getAsJsonArray).map(StructureReader::toVector3i);
            Path schemFile = path.resolveSibling(schemFileName);
            String schemName = SCHEM_PATTERN.matcher(path.getFileName().toString()).replaceAll("");
            Schematic schematic = new SchematicReader().read(schemFile);
            Map<StructureMeta<?>, Object> structureMeta = jsonObject.get("meta").getAsJsonObject().entrySet().stream().map(entry -> {
                StructureMeta<?> meta = dev.jsinco.brewery.util.Registry.STRUCTURE_META.get(BreweryKey.parse((String)entry.getKey()));
                if (meta == null) {
                    throw new StructureReadException("Unknown meta: " + (String)entry.getKey());
                }
                Object value = meta.deserializer().apply((JsonElement)entry.getValue());
                return new Pair(meta, value);
            }).collect(Collectors.toMap(Pair::first, Pair::second));
            BreweryStructure breweryStructure = origin.map(vector3i -> new BreweryStructure(schematic, List.of(vector3i), schemName, structureMeta)).orElse(new BreweryStructure(schematic, schemName, structureMeta));
            return breweryStructure;
        }
    }

    private static Set<Material> parseMaterials(String materialString) throws StructureReadException {
        String[] split = materialString.split(",");
        HashSet<Material> output = new HashSet<Material>();
        for (String arg : split) {
            Matcher tagMatcher = TAG_PATTERN.matcher(arg);
            if (tagMatcher.find()) {
                String tagName = tagMatcher.replaceAll("").toLowerCase(Locale.ROOT);
                Tag materialsTag = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)tagName), Material.class);
                if (materialsTag == null) {
                    throw new StructureReadException("Unknown material tag: " + String.valueOf(NamespacedKey.minecraft((String)tagName)));
                }
                output.addAll(materialsTag.getValues());
                continue;
            }
            Material material = (Material)Registry.MATERIAL.get(NamespacedKey.minecraft((String)arg.toLowerCase(Locale.ROOT)));
            if (material == null) {
                throw new StructureReadException("Unknown material: " + String.valueOf(NamespacedKey.minecraft((String)arg.toLowerCase(Locale.ROOT))));
            }
            output.add(material);
        }
        return output;
    }

    private static Vector3i toVector3i(JsonArray jsonArray) {
        return new Vector3i(jsonArray.get(0).getAsInt(), jsonArray.get(1).getAsInt(), jsonArray.get(2).getAsInt());
    }
}

