/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.util;

import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.integration.IntegrationType;
import dev.jsinco.brewery.bukkit.integration.PlaceholderIntegration;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffects;
import dev.jsinco.brewery.configuration.locale.TranslationsConfig;
import dev.jsinco.brewery.effect.DrunkStateImpl;
import dev.jsinco.brewery.effect.DrunksManagerImpl;
import dev.jsinco.brewery.event.NamedDrunkEvent;
import dev.jsinco.brewery.util.MessageUtil;
import java.util.Locale;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class BukkitMessageUtil {
    private BukkitMessageUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static TagResolver recipeEffectResolver(RecipeEffects effects) {
        return TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.component((String)"potion_effects", (ComponentLike)((ComponentLike)effects.getEffects().stream().map(effect -> (TranslatableComponent)Component.translatable((String)effect.type().translationKey()).append((Component)Component.text((String)("/" + String.valueOf(effect.durationRange()) + "/" + String.valueOf(effect.amplifierRange()))))).collect(Component.toComponent((Component)Component.text((String)","))))), Formatter.number((String)"effect_alcohol", (Number)effects.getAlcohol()), Formatter.number((String)"effect_toxins", (Number)effects.getToxins()), Placeholder.parsed((String)"effect_title_message", (String)(effects.getTitle() == null ? "" : effects.getTitle())), Placeholder.parsed((String)"effect_message", (String)(effects.getMessage() == null ? "" : effects.getMessage())), Placeholder.parsed((String)"effect_action_bar", (String)(effects.getActionBar() == null ? "" : effects.getActionBar())), Placeholder.parsed((String)"effect_events", (String)effects.getEvents().stream().map(drunkEvent -> {
            if (drunkEvent instanceof NamedDrunkEvent) {
                NamedDrunkEvent namedDrunkEvent = (NamedDrunkEvent)drunkEvent;
                return TranslationsConfig.EVENT_TYPES.get(namedDrunkEvent.displayName().toLowerCase(Locale.ROOT));
            }
            return drunkEvent.displayName();
        }).collect(Collectors.joining(",")))});
    }

    public static Component compilePlayerMessage(String message, Player player, DrunksManagerImpl<?> drunksManager, int alcohol) {
        DrunkStateImpl drunkState = drunksManager.getDrunkState(player.getUniqueId());
        return MessageUtil.miniMessage(BukkitMessageUtil.preProcessPlayerMessage(message, player), new TagResolver[]{Placeholder.parsed((String)"alcohol", (String)String.valueOf(alcohol)), Placeholder.parsed((String)"player_alcohol", (String)String.valueOf(drunkState == null ? "0" : Integer.valueOf(drunkState.alcohol()))), BukkitMessageUtil.getPlayerTagResolver(player)});
    }

    public static TagResolver getPlayerTagResolver(Player player) {
        return TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.component((String)"player_name", (ComponentLike)player.name()), Placeholder.component((String)"team_name", (ComponentLike)player.teamDisplayName()), Placeholder.unparsed((String)"world", (String)player.getWorld().getName()), TagResolver.resolver((TagResolver[])((TagResolver[])TheBrewingProject.getInstance().getIntegrationManager().retrieve(IntegrationType.PLACEHOLDER).stream().map(placeholderIntegration -> placeholderIntegration.resolve((OfflinePlayer)player)).toArray(TagResolver[]::new)))});
    }

    private static String preProcessPlayerMessage(String message, Player player) {
        String modifiedMessage = message;
        for (PlaceholderIntegration placeholderIntegration : TheBrewingProject.getInstance().getIntegrationManager().retrieve(IntegrationType.PLACEHOLDER)) {
            modifiedMessage = placeholderIntegration.process(modifiedMessage, (OfflinePlayer)player);
        }
        return modifiedMessage;
    }
}

