/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration;

import dev.jsinco.brewery.lib.org.simpleyaml.configuration.ConfigurationSection;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.comments.CommentType;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.file.YamlConfiguration;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.file.YamlFile;
import dev.jsinco.brewery.lib.org.simpleyaml.exceptions.InvalidConfigurationException;
import dev.jsinco.brewery.util.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfig {
    private YamlFile config;
    private YamlConfiguration backup;

    @NotNull
    public YamlFile getConfig() {
        return this.config;
    }

    protected void reload(@NotNull Path path, String defaultLocation, @NotNull @NotNull Class<? extends @NotNull AbstractConfig> clazz) {
        this.config = new YamlFile(path.toFile());
        try (InputStream inputStream = AbstractConfig.class.getResourceAsStream("/" + defaultLocation);){
            this.backup = YamlConfiguration.loadConfiguration(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.getConfig().createOrLoadWithComments();
        }
        catch (InvalidConfigurationException e) {
            Logger.logErr("Could not load " + String.valueOf(path.getFileName()) + ", please correct your syntax errors");
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        @Nullable Header header = clazz.getDeclaredAnnotation(Header.class);
        if (header != null) {
            this.config.setHeader(header.value());
        }
        Arrays.stream(clazz.getDeclaredFields()).forEach(field -> {
            Key key = field.getDeclaredAnnotation(Key.class);
            Comment comment = field.getDeclaredAnnotation(Comment.class);
            if (key == null) {
                return;
            }
            try {
                Object value = this.getValue(key.value(), field.get(null));
                field.set(null, value);
                if (comment != null) {
                    this.setComment(key.value(), comment.value());
                }
            }
            catch (Throwable e) {
                Logger.logErr("Failed to load " + key.value() + " from " + path.getFileName().toString());
                Logger.logErr(e);
            }
        });
        this.save();
    }

    protected void save() {
        try {
            this.getConfig().save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    protected Object getValue(@NotNull String path, @Nullable Object def) {
        if (def == null) {
            def = this.backup.get(path);
        }
        if (this.getConfig().get(path) == null) {
            this.set(path, def);
        }
        return this.get(path, def);
    }

    protected void setComment(@NotNull String path, @Nullable String comment) {
        this.getConfig().setComment(path, comment, CommentType.BLOCK);
    }

    @Nullable
    protected Object get(@NotNull String path, @Nullable Object def) {
        Object val = this.get(path, this.getConfig());
        return val == null ? def : val;
    }

    @Nullable
    protected Object get(@NotNull String path, YamlConfiguration configuration) {
        Object value = configuration.get(path);
        if (!(value instanceof ConfigurationSection)) {
            return value;
        }
        Object object = this.backup.get(path);
        if (!(object instanceof ConfigurationSection)) {
            throw new IllegalArgumentException("Expected '" + path + "' to be a configuration section");
        }
        ConfigurationSection backupSection = (ConfigurationSection)object;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : backupSection.getKeys(false)) {
            String keyPath = path + "." + key;
            Object rawValue = this.get(keyPath, configuration);
            if (rawValue == null && configuration != this.backup) {
                rawValue = this.get(keyPath, this.backup);
                if (rawValue == null) continue;
                this.set(keyPath, rawValue);
            }
            map.put(key, rawValue);
        }
        return map;
    }

    protected void set(@NotNull String path, @Nullable Object value) {
        this.getConfig().set(path, value);
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Header {
        @NotNull
        public String value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Key {
        @NotNull
        public String value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Comment {
        @NotNull
        public String value();
    }
}

