/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.database.sql;

import dev.jsinco.brewery.util.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class SqlStatements {
    private final String folder;
    private final Map<Type, String> statements = new ConcurrentHashMap<Type, String>();

    public SqlStatements(String folder) {
        this.folder = folder;
        this.init();
    }

    public void init() {
        for (Type type : Type.values()) {
            try (InputStream inputStream = SqlStatements.class.getResourceAsStream(type.path(this.folder));){
                if (inputStream == null) continue;
                String statement = new String(inputStream.readAllBytes());
                this.statements.put(type, statement);
            }
            catch (IOException e) {
                Logger.logErr(e);
            }
        }
    }

    @NotNull
    public String get(Type type) {
        if (!this.statements.containsKey((Object)type)) {
            throw new IllegalArgumentException("Statement does not exists.");
        }
        return this.statements.get((Object)type);
    }

    public static enum Type {
        SELECT_ALL,
        DELETE,
        UPDATE,
        INSERT,
        FIND,
        GET_SINGLETON,
        SET_SINGLETON;


        public String path(String directoryPath) {
            return directoryPath + "/" + this.name().toLowerCase(Locale.ROOT) + ".sql";
        }
    }
}

