/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.effect.text;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.jsinco.brewery.effect.text.DrunkTextElement;
import dev.jsinco.brewery.effect.text.DrunkTextPattern;
import dev.jsinco.brewery.effect.text.SingleDrunkTextElement;
import dev.jsinco.brewery.util.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DrunkTextRegistry {
    Map<Integer, List<DrunkTextElement>> drunkenTexts = new HashMap<Integer, List<DrunkTextElement>>();

    public void load(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            for (JsonElement element : jsonArray) {
                int alcohol;
                JsonObject jsonObject = element.getAsJsonObject();
                String replace = jsonObject.has("from") ? jsonObject.get("from").getAsString() : null;
                String replacement = jsonObject.get("to").getAsString();
                int percentage = jsonObject.get("percentage").getAsInt();
                int n = alcohol = jsonObject.has("alcohol") ? jsonObject.get("alcohol").getAsInt() : 0;
                if (alcohol < 0 || alcohol > 100) {
                    Logger.logErr("Alcohol outside range for element: " + String.valueOf(jsonObject));
                    continue;
                }
                if (percentage < 0 || percentage > 100) {
                    Logger.logErr("Percentage outside range for element: " + String.valueOf(jsonObject));
                    continue;
                }
                Record drunkTextElement = replace != null ? new DrunkTextPattern(Pattern.compile(replace, 2), replacement, percentage, alcohol) : new SingleDrunkTextElement(replacement, percentage, alcohol);
                for (int i = alcohol; i <= 100; ++i) {
                    this.drunkenTexts.computeIfAbsent(i, ignored -> new ArrayList()).add(drunkTextElement);
                }
            }
        }
    }

    public List<DrunkTextElement> getTextTransformers(int alcohol) {
        Preconditions.checkArgument((alcohol >= 0 && alcohol <= 100 ? 1 : 0) != 0, (Object)"Alcohol outside range");
        return this.drunkenTexts.computeIfAbsent(alcohol, ignored -> new ArrayList());
    }

    public void clear() {
        this.drunkenTexts.clear();
    }
}

