/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.lib.org.simpleyaml.configuration;

import dev.jsinco.brewery.lib.org.simpleyaml.configuration.Configuration;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.ConfigurationSection;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.MemoryConfigurationOptions;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.MemorySection;
import dev.jsinco.brewery.lib.org.simpleyaml.utils.Validate;
import java.util.Map;

public class MemoryConfiguration
extends MemorySection
implements Configuration {
    protected Configuration defaults;
    protected MemoryConfigurationOptions options;

    public MemoryConfiguration() {
    }

    public MemoryConfiguration(Configuration defaults) {
        this.defaults = defaults;
    }

    @Override
    public void addDefaults(Map<String, Object> defaults) {
        Validate.notNull(defaults, "Defaults may not be null");
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            this.addDefault(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void addDefaults(Configuration defaults) {
        Validate.notNull(defaults, "Defaults may not be null");
        for (String key : defaults.getKeys(true)) {
            if (defaults.isConfigurationSection(key)) continue;
            this.addDefault(key, defaults.get(key));
        }
    }

    @Override
    public Configuration getDefaults() {
        return this.defaults;
    }

    @Override
    public void setDefaults(Configuration defaults) {
        Validate.notNull(defaults, "Defaults may not be null");
        this.defaults = defaults;
    }

    @Override
    public MemoryConfigurationOptions options() {
        if (this.options == null) {
            this.options = new MemoryConfigurationOptions(this);
        }
        return this.options;
    }

    @Override
    public ConfigurationSection getParent() {
        return null;
    }

    @Override
    public void addDefault(String path, Object value) {
        Validate.notNull(path, "Path may not be null");
        if (this.defaults == null) {
            this.defaults = new MemoryConfiguration();
        }
        this.defaults.set(path, value);
    }
}

