/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.moment;

import dev.jsinco.brewery.moment.Moment;
import org.jetbrains.annotations.NotNull;

public record Interval(long start, long stop) implements Moment
{
    @Override
    public long moment() {
        return this.stop - this.start;
    }

    @Override
    public Interval withLastStep(long lastStep) {
        return new Interval(this.start, lastStep);
    }

    @Override
    public Interval withMovedEnding(long newEnd) {
        return new Interval(newEnd - this.stop + this.start, newEnd);
    }

    public static Interval parse(@NotNull Object value) throws IllegalArgumentException {
        if (value instanceof String) {
            String string = (String)value;
            return Interval.parseString(string);
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return new Interval(integer.intValue(), integer.intValue());
        }
        throw new IllegalArgumentException("Illegal value: " + String.valueOf(value));
    }

    public static Interval parseString(@NotNull String string) {
        if (string.contains(";")) {
            String[] split = string.split(";");
            return new Interval(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
        }
        if (!string.contains("-")) {
            int i = Integer.parseInt(string);
            return new Interval(i, i);
        }
        String[] split = string.split("-");
        return new Interval(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
    }

    @Override
    @NotNull
    public String toString() {
        return this.start + ";" + this.stop;
    }

    public String asString() {
        if (this.start == this.stop) {
            return String.valueOf(this.start);
        }
        return String.format("%d;%d", this.start, this.stop);
    }
}

