/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.util;

import org.jetbrains.annotations.Contract;

public class Pair<A, B> {
    private final A a;
    private final B b;

    public Pair(A a, B b) {
        this.a = a;
        this.b = b;
    }

    @Contract(pure=true)
    public A first() {
        return this.a;
    }

    @Contract(pure=true)
    public B second() {
        return this.b;
    }

    @Contract(pure=true)
    public A a() {
        return this.a;
    }

    @Contract(pure=true)
    public B b() {
        return this.b;
    }

    public static <K> Pair<K, K> singleValue(K val) {
        return new Pair<K, K>(val, val);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)object;
        return pair.a().equals(this.a()) && pair.b().equals(this.b());
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode();
    }

    public String toString() {
        return "Pair{a=" + String.valueOf(this.a) + ", b=" + String.valueOf(this.b) + "}";
    }
}

