/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.util;

import dev.jsinco.brewery.util.WeightedProbabilityElement;
import java.util.List;
import java.util.Random;

public class RandomUtil {
    private static final Random RANDOM = new Random();

    public static <T extends WeightedProbabilityElement> T randomWeighted(List<T> tList) {
        int[] cumulativeSums = new int[tList.size()];
        int cumulativeSum = 0;
        for (int i = 0; i < tList.size(); ++i) {
            WeightedProbabilityElement drunkEvent = (WeightedProbabilityElement)tList.get(i);
            cumulativeSums[i] = cumulativeSum += drunkEvent.probabilityWeight();
        }
        int randomInt = RANDOM.nextInt(cumulativeSum);
        for (int i = 0; i < tList.size(); ++i) {
            if (cumulativeSums[i] <= randomInt) continue;
            return (T)((WeightedProbabilityElement)tList.get(i));
        }
        return (T)((WeightedProbabilityElement)tList.getLast());
    }

    public static int cumulativeSum(List<? extends WeightedProbabilityElement> tList) {
        int cumulativeSum = 0;
        for (int i = 0; i < tList.size(); ++i) {
            WeightedProbabilityElement drunkEvent = tList.get(i);
            cumulativeSum += drunkEvent.probabilityWeight();
        }
        return cumulativeSum;
    }
}

