/*
 * Decompiled with CFR 0.152.
 */
package net.gobies.potionrings2.item.potionrings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.gobies.potionrings2.PRConfig;
import net.gobies.potionrings2.init.PRItems;
import net.gobies.potionrings2.util.RingHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class PotionRingItem
extends Item
implements ICurioItem {
    public PotionRingItem(Item.Properties properties) {
        super(properties.m_41487_(1).m_41497_(Rarity.COMMON));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        String effectIdString;
        ResourceLocation effectId;
        MobEffect effect;
        LivingEntity entity = slotContext.entity();
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("Effect") && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectId = new ResourceLocation(effectIdString = nbt.m_128461_("Effect")))) != null) {
            int ringCount = RingHandler.getEquippedRingCount(entity, (Item)PRItems.PotionRing.get(), effectIdString);
            int effectLevel = Math.min(ringCount - 1, 2);
            entity.m_7292_(new MobEffectInstance(effect, -1, effectLevel, true, false));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        String effectIdString;
        ResourceLocation effectId;
        MobEffect effect;
        LivingEntity entity = slotContext.entity();
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("Effect") && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectId = new ResourceLocation(effectIdString = nbt.m_128461_("Effect")))) != null) {
            entity.m_21195_(effect);
            List<ItemStack> equippedRings = RingHandler.getEquippedRings(entity, (Item)PRItems.PotionRing.get());
            for (ItemStack equippedRing : equippedRings) {
                String equippedEffectIdString;
                ResourceLocation equippedEffectId;
                MobEffect equippedEffect;
                CompoundTag equippedRingNbt = equippedRing.m_41783_();
                if (equippedRingNbt == null || !equippedRingNbt.m_128441_("Effect") || (equippedEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(equippedEffectId = new ResourceLocation(equippedEffectIdString = equippedRingNbt.m_128461_("Effect")))) == null) continue;
                int ringCount = RingHandler.getEquippedRingCount(entity, (Item)PRItems.PotionRing.get(), equippedEffectIdString);
                int effectLevel = Math.min(ringCount - 1, 2);
                entity.m_7292_(new MobEffectInstance(equippedEffect, -1, effectLevel, true, false));
            }
        }
    }

    public boolean m_6832_(@Nonnull ItemStack item, @NotNull ItemStack material) {
        return this == Items.f_42417_;
    }

    public static boolean hasEffect(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_("Effect");
    }

    public static List<ItemStack> createPotionRing() {
        ArrayList<ItemStack> potionRings = new ArrayList<ItemStack>();
        for (String effectIdString : (List)PRConfig.EFFECTS.get()) {
            ResourceLocation effectId = new ResourceLocation(effectIdString);
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectId);
            if (effect == null) continue;
            ItemStack potionRing = new ItemStack((ItemLike)PRItems.PotionRing.get());
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("Effect", effectIdString);
            potionRing.m_41751_(nbt);
            potionRings.add(potionRing);
        }
        return potionRings;
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return PotionRingItem.hasEffect(pStack);
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    @NotNull
    public Component m_7626_(ItemStack pStack) {
        String effectIdString;
        ResourceLocation effectId;
        MobEffect effect;
        CompoundTag nbt = pStack.m_41783_();
        if (nbt != null && nbt.m_128441_("Effect") && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectId = new ResourceLocation(effectIdString = nbt.m_128461_("Effect")))) != null) {
            return Component.m_237110_((String)"item.potionrings2.potion_ring_of", (Object[])new Object[]{effect.m_19482_()});
        }
        return super.m_7626_(pStack);
    }
}

