/*
 * Decompiled with CFR 0.152.
 */
package com.mrerenk.mapdistancefix.util;

import com.mrerenk.mapdistancefix.client.MapdistancefixClient;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_20;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public final class MapIconUtils {
    public static final float DEGREES_PER_ROTATION = 22.5f;
    public static final int ROTATION_MASK = 15;
    private static final byte[] ROTATION_LOOKUP = new byte[360];
    private static final ThreadLocal<Boolean> IS_PLAYER_CONTEXT = ThreadLocal.withInitial(() -> false);
    private static final AtomicReference<WeakReference<class_20.class_21>> cachedPlayerTypeRef;

    private MapIconUtils() {
    }

    public static byte calculateMapRotation(float playerYaw) {
        int normalizedYaw = ((int)class_3532.method_15393((float)playerYaw) + 360) % 360;
        return ROTATION_LOOKUP[normalizedYaw];
    }

    private static class_20.class_21 getIconType(class_20 icon) {
        return icon.method_93();
    }

    private static byte getIconX(class_20 icon) {
        return icon.method_90();
    }

    private static byte getIconZ(class_20 icon) {
        return icon.method_91();
    }

    private static class_2561 getIconText(class_20 icon) {
        return icon.method_88();
    }

    public static Optional<class_20> convertOffMapIcon(class_20 original, byte newRotation) {
        return Optional.ofNullable(original).filter(MapIconUtils::isPlayerOffMapAny).map(icon -> {
            PlayerIconType.fromType(MapIconUtils.getIconType(icon)).ifPresent(type -> MapdistancefixClient.LOGGER.debug("Converting {} icon to player icon", (Object)type.getDisplayName()));
            return new class_20(MapIconUtils.getPlayerType(), MapIconUtils.getIconX(icon), MapIconUtils.getIconZ(icon), newRotation, MapIconUtils.getIconText(icon));
        });
    }

    public static boolean shouldConvertIconType(class_20.class_21 type) {
        if (type == null) {
            return false;
        }
        return type == class_20.class_21.field_86 || type == class_20.class_21.field_87;
    }

    public static boolean isPlayerOffMapAny(class_20 icon) {
        return icon != null && MapIconUtils.shouldConvertIconType(MapIconUtils.getIconType(icon));
    }

    public static boolean isPlayerContext() {
        StackTraceElement[] stack;
        if (IS_PLAYER_CONTEXT.get().booleanValue()) {
            return true;
        }
        for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
            String className = element.getClassName();
            if (!className.contains("MapState") && !className.contains("class_22")) continue;
            return true;
        }
        return false;
    }

    public static void setPlayerContext(boolean inPlayerContext) {
        IS_PLAYER_CONTEXT.set(inPlayerContext);
    }

    public static void clearPlayerContext() {
        IS_PLAYER_CONTEXT.remove();
    }

    public static void cachePlayerTypeFromIcon(class_20 icon) {
        if (icon == null) {
            return;
        }
        class_20.class_21 iconType = MapIconUtils.getIconType(icon);
        if (iconType == class_20.class_21.field_91) {
            WeakReference<class_20.class_21> newRef = new WeakReference<class_20.class_21>(iconType);
            cachedPlayerTypeRef.compareAndSet(null, newRef);
            MapdistancefixClient.LOGGER.debug("Cached player icon type from game instance");
        }
    }

    public static class_20.class_21 getPlayerType() {
        WeakReference<class_20.class_21> ref = cachedPlayerTypeRef.get();
        if (ref != null) {
            class_20.class_21 cached = (class_20.class_21)ref.get();
            if (cached != null) {
                return cached;
            }
            cachedPlayerTypeRef.compareAndSet(ref, null);
        }
        return class_20.class_21.field_91;
    }

    public static boolean isPlayerType(class_20.class_21 type) {
        if (type == null) {
            return false;
        }
        return type == class_20.class_21.field_91 || type == class_20.class_21.field_86 || type == class_20.class_21.field_87;
    }

    static {
        for (int i = 0; i < 360; ++i) {
            MapIconUtils.ROTATION_LOOKUP[i] = (byte)(Math.round((float)i / 22.5f) & 0xF);
        }
        cachedPlayerTypeRef = new AtomicReference<Object>(null);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum PlayerIconType {
        PLAYER(class_20.class_21.field_91, "player"),
        OFF_MAP(class_20.class_21.field_86, "off-map"),
        OFF_LIMITS(class_20.class_21.field_87, "off-limits");

        private final class_20.class_21 type;
        private final String displayName;

        private PlayerIconType(class_20.class_21 type, String displayName) {
            this.type = type;
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static Optional<PlayerIconType> fromType(class_20.class_21 type) {
            for (PlayerIconType iconType : PlayerIconType.values()) {
                if (!iconType.type.equals((Object)type)) continue;
                return Optional.of(iconType);
            }
            return Optional.empty();
        }
    }
}

