/*
 * Decompiled with CFR 0.152.
 */
package com.mrerenk.mapdistancefix.util;

import com.mojang.logging.LogUtils;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import org.slf4j.Logger;

public final class MapDecorationUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final float DEGREES_PER_ROTATION = 22.5f;
    public static final int ROTATION_MASK = 15;
    private static final byte[] ROTATION_LOOKUP = new byte[360];
    private static final ThreadLocal<Boolean> IS_PLAYER_CONTEXT = ThreadLocal.withInitial(() -> false);
    private static final AtomicReference<WeakReference<MapDecoration.Type>> cachedPlayerTypeRef;

    private MapDecorationUtils() {
    }

    public static byte calculateMapRotation(float playerYaw) {
        int normalizedYaw = ((int)Mth.m_14177_((float)playerYaw) + 360) % 360;
        return ROTATION_LOOKUP[normalizedYaw];
    }

    private static MapDecoration.Type getIconType(MapDecoration icon) {
        return icon.m_77803_();
    }

    private static byte getIconX(MapDecoration icon) {
        return icon.m_77804_();
    }

    private static byte getIconY(MapDecoration icon) {
        return icon.m_77805_();
    }

    private static Component getIconText(MapDecoration icon) {
        return icon.m_77810_();
    }

    public static Optional<MapDecoration> convertOffMapIcon(MapDecoration original, byte newRotation) {
        return Optional.ofNullable(original).filter(MapDecorationUtils::isPlayerOffMapAny).map(icon -> {
            PlayerIconType.fromType(MapDecorationUtils.getIconType(icon)).ifPresent(type -> LOGGER.debug("Converting {} icon to player icon", (Object)type.getDisplayName()));
            return new MapDecoration(MapDecorationUtils.getPlayerType(), MapDecorationUtils.getIconX(icon), MapDecorationUtils.getIconY(icon), newRotation, MapDecorationUtils.getIconText(icon));
        });
    }

    public static boolean shouldConvertIconType(MapDecoration.Type type) {
        if (type == null) {
            return false;
        }
        return type == MapDecoration.Type.PLAYER_OFF_MAP || type == MapDecoration.Type.PLAYER_OFF_LIMITS;
    }

    public static boolean isPlayerOffMapAny(MapDecoration icon) {
        return icon != null && MapDecorationUtils.shouldConvertIconType(MapDecorationUtils.getIconType(icon));
    }

    public static boolean isPlayerContext() {
        StackTraceElement[] stack;
        if (IS_PLAYER_CONTEXT.get().booleanValue()) {
            return true;
        }
        for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
            String className = element.getClassName();
            if (!className.contains("MapItemSavedData") && !className.contains("class_22")) continue;
            return true;
        }
        return false;
    }

    public static void setPlayerContext(boolean inPlayerContext) {
        IS_PLAYER_CONTEXT.set(inPlayerContext);
    }

    public static void clearPlayerContext() {
        IS_PLAYER_CONTEXT.remove();
    }

    public static void cachePlayerTypeFromIcon(MapDecoration icon) {
        if (icon == null) {
            return;
        }
        MapDecoration.Type iconType = MapDecorationUtils.getIconType(icon);
        if (iconType == MapDecoration.Type.PLAYER) {
            WeakReference<MapDecoration.Type> newRef = new WeakReference<MapDecoration.Type>(iconType);
            cachedPlayerTypeRef.compareAndSet(null, newRef);
            LOGGER.debug("Cached player icon type from game instance");
        }
    }

    public static MapDecoration.Type getPlayerType() {
        WeakReference<MapDecoration.Type> ref = cachedPlayerTypeRef.get();
        if (ref != null) {
            MapDecoration.Type cached = (MapDecoration.Type)ref.get();
            if (cached != null) {
                return cached;
            }
            cachedPlayerTypeRef.compareAndSet(ref, null);
        }
        return MapDecoration.Type.PLAYER;
    }

    public static boolean isPlayerType(MapDecoration.Type type) {
        if (type == null) {
            return false;
        }
        return type == MapDecoration.Type.PLAYER || type == MapDecoration.Type.PLAYER_OFF_MAP || type == MapDecoration.Type.PLAYER_OFF_LIMITS;
    }

    static {
        for (int i = 0; i < 360; ++i) {
            MapDecorationUtils.ROTATION_LOOKUP[i] = (byte)(Math.round((float)i / 22.5f) & 0xF);
        }
        cachedPlayerTypeRef = new AtomicReference<Object>(null);
    }

    public static enum PlayerIconType {
        PLAYER(MapDecoration.Type.PLAYER, "player"),
        OFF_MAP(MapDecoration.Type.PLAYER_OFF_MAP, "off-map"),
        OFF_LIMITS(MapDecoration.Type.PLAYER_OFF_LIMITS, "off-limits");

        private final MapDecoration.Type type;
        private final String displayName;

        private PlayerIconType(MapDecoration.Type type, String displayName) {
            this.type = type;
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static Optional<PlayerIconType> fromType(MapDecoration.Type type) {
            for (PlayerIconType iconType : PlayerIconType.values()) {
                if (!iconType.type.equals((Object)type)) continue;
                return Optional.of(iconType);
            }
            return Optional.empty();
        }
    }
}

