#version 150

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:globals.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec4 tintColor;
in vec4 lightMapColor;
in vec2 texCoord0;
in vec2 texCoord1;

out vec4 fragColor;

void main() {
    #moj_import <minecraft:code/animate_texture.glsl>
    vec4 color = texture(Sampler0, newCoord) * ColorModulator;
    if (color.a < 0.1) {
        discard;
    }
    #moj_import <minecraft:code/fix_colors.glsl>
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
