/*
 * Decompiled with CFR 0.152.
 */
package com.loracore;

import com.loracore.LoraCoreMod;
import com.loracore.service.AiService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class StructureNameManager
extends class_18 {
    private static final String ID = "loracore_structure_names";
    private final Map<String, StructureData> structureDataMap = new ConcurrentHashMap<String, StructureData>();

    public static StructureNameManager createFromNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        StructureNameManager manager = new StructureNameManager();
        class_2499 list = nbt.method_10554("structures", 10);
        for (class_2520 element : list) {
            class_2487 compound = (class_2487)element;
            String posKey = compound.method_10558("pos");
            StructureData data = new StructureData(compound);
            manager.structureDataMap.put(posKey, data);
        }
        LoraCoreMod.LOGGER.info("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e {} \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u043e \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430\u0445.", (Object)manager.structureDataMap.size());
        return manager;
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 lookup) {
        class_2499 list = new class_2499();
        for (Map.Entry<String, StructureData> entry : this.structureDataMap.entrySet()) {
            class_2487 compound = entry.getValue().writeNbt();
            compound.method_10582("pos", entry.getKey());
            list.add((Object)compound);
        }
        nbt.method_10566("structures", (class_2520)list);
        LoraCoreMod.LOGGER.info("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e {} \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u043e \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430\u0445.", (Object)this.structureDataMap.size());
        return nbt;
    }

    public static StructureNameManager get(class_3218 world) {
        class_26 stateManager = world.method_17983();
        class_18.class_8645 type = new class_18.class_8645(StructureNameManager::new, StructureNameManager::createFromNbt, null);
        return (StructureNameManager)stateManager.method_17924(type, ID);
    }

    public StructureCheckResult getOrCreateStructureDataAt(class_3218 world, class_2338 playerPos) {
        List<class_6862> structureTags = List.of(class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960("minecraft", "village")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960("minecraft", "pillager_outpost")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960("minecraft", "mineshaft")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960("minecraft", "desert_pyramid")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960("minecraft", "jungle_temple")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960("minecraft", "ocean_monument")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960("minecraft", "stronghold")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960("minecraft", "mansion")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960("minecraft", "ruined_portal")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960("minecraft", "shipwreck")), class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960("minecraft", "swamp_hut")));
        class_2378 structureRegistry = world.method_30349().method_30530(class_7924.field_41246);
        for (class_6862 tag : structureTags) {
            Optional entryListOptional = structureRegistry.method_40266(tag);
            if (entryListOptional.isEmpty()) continue;
            for (class_6880 structureEntry : (class_6885.class_6888)entryListOptional.get()) {
                class_3449 structureStart;
                Optional keyOptional = structureEntry.method_40230();
                if (keyOptional.isEmpty() || (structureStart = world.method_27056().method_28388(playerPos, (class_3195)structureEntry.comp_349())) == null || !structureStart.method_16657()) continue;
                class_2338 structureCenter = structureStart.method_14969().method_22874();
                String posKey = structureCenter.method_10263() + "," + structureCenter.method_10264() + "," + structureCenter.method_10260();
                StructureData data = this.structureDataMap.computeIfAbsent(posKey, k -> {
                    StructureData newData = new StructureData("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430...", "\u041f\u043e\u043b\u0443\u0447\u0430\u0435\u043c \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435...");
                    newData.isGenerating.set(true);
                    class_6880 biomeEntry = world.method_23753(playerPos);
                    String biomeId = biomeEntry.method_40230().map(class_5321::method_29177).orElse(new class_2960("minecraft", "unknown_biome")).toString();
                    LoraCoreMod.LOGGER.info("\u041d\u0430\u0439\u0434\u0435\u043d\u0430 \u043d\u043e\u0432\u0430\u044f \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 (\u0442\u0435\u0433 '{}') \u0432 \u0431\u0438\u043e\u043c\u0435 '{}' \u043f\u043e \u043f\u043e\u0437\u0438\u0446\u0438\u0438 {}. \u0417\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u043c \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044e \u0438\u043c\u0435\u043d\u0438 AI.", new Object[]{tag.comp_327(), biomeId, posKey});
                    AiService.generateStructureInfo(tag.comp_327().toString(), biomeId).whenCompleteAsync((generatedInfo, error) -> {
                        MinecraftServer server = world.method_8503();
                        server.execute(() -> {
                            if (error != null) {
                                LoraCoreMod.LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0438\u043c\u0435\u043d\u0438 AI \u0434\u043b\u044f \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u044b \u0432 {}: {}", (Object)posKey, (Object)error.getMessage());
                                this.structureDataMap.put(posKey, new StructureData("\u041e\u0448\u0438\u0431\u043a\u0430 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438", "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435."));
                            } else {
                                LoraCoreMod.LOGGER.info("AI \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043b \u0438\u043c\u044f '{}' \u0438 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 '{}' \u0434\u043b\u044f \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u044b \u0432 {}.", new Object[]{generatedInfo.name(), generatedInfo.description(), posKey});
                                this.structureDataMap.put(posKey, new StructureData(generatedInfo.name(), generatedInfo.description()));
                            }
                            StructureData currentData = this.structureDataMap.get(posKey);
                            if (currentData != null) {
                                currentData.isGenerating.set(false);
                            }
                            this.method_80();
                        });
                    }, (Executor)world.method_8503());
                    return newData;
                });
                return new StructureCheckResult(Optional.of(data), Optional.of(posKey));
            }
        }
        return StructureCheckResult.empty();
    }

    public static class StructureData {
        public String name;
        public String description;
        public AtomicBoolean isGenerating = new AtomicBoolean(false);

        public StructureData(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public StructureData(class_2487 nbt) {
            this.name = nbt.method_10558("name");
            this.description = nbt.method_10558("description");
        }

        public class_2487 writeNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10582("name", this.name);
            nbt.method_10582("description", this.description);
            return nbt;
        }
    }

    public static class StructureCheckResult {
        private final Optional<StructureData> data;
        private final Optional<String> posKey;

        public StructureCheckResult(Optional<StructureData> data, Optional<String> posKey) {
            this.data = data;
            this.posKey = posKey;
        }

        public Optional<StructureData> getData() {
            return this.data;
        }

        public Optional<String> getPosKey() {
            return this.posKey;
        }

        public static StructureCheckResult empty() {
            return new StructureCheckResult(Optional.empty(), Optional.empty());
        }
    }
}

