/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.gui;

import com.loracore.ModConfigScreen;
import com.loracore.api.dto.OpenAiApiDto;
import com.loracore.component.ModComponents;
import com.loracore.component.PlayerAskHistoryComponent;
import com.loracore.network.AskAiC2SPacket;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8666;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class AskChatScreen
extends class_437 {
    private static final class_2960 SETTINGS_ICON_TEXTURE = new class_2960("loracore", "textures/gui/settings_icon.png");
    private class_342 inputBox;
    private double scrollAmount;
    private int visibleHistoryHeight;
    private int totalHistoryHeight;

    public AskChatScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.loracore.ask.title"));
    }

    protected void method_25426() {
        super.method_25426();
        Objects.requireNonNull(this.field_22787);
        int chatAreaY = 32;
        int chatAreaHeight = this.field_22790 - chatAreaY - 40;
        this.visibleHistoryHeight = chatAreaHeight - 10;
        this.inputBox = new class_342(this.field_22793, this.field_22789 / 2 - 150, this.field_22790 - 28, 260, 20, (class_2561)class_2561.method_43471((String)"gui.loracore.ask.input_placeholder"));
        this.inputBox.method_1880(256);
        this.method_37063((class_364)this.inputBox);
        class_4185 sendButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.loracore.dialogue.button.send"), button -> this.sendMessage()).method_46434(this.field_22789 / 2 + 115, this.field_22790 - 28, 40, 20).method_46431();
        this.method_37063((class_364)sendButton);
        class_344 settingsButton = new class_344(this.field_22789 - 25, 5, 20, 20, new class_8666(SETTINGS_ICON_TEXTURE, SETTINGS_ICON_TEXTURE), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(ModConfigScreen.create(this));
            }
        });
        this.method_37063((class_364)settingsButton);
        this.method_48265((class_364)this.inputBox);
    }

    private void sendMessage() {
        String question = this.inputBox.method_1882().trim();
        if (!question.isEmpty() && this.field_22787 != null && this.field_22787.field_1724 != null) {
            String langCode = this.field_22787.method_1526().method_4669();
            ClientPlayNetworking.send((class_8710)new AskAiC2SPacket(question, langCode));
            this.inputBox.method_1852("");
            this.scrollAmount = Math.max(0, this.totalHistoryHeight - this.visibleHistoryHeight);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.inputBox.method_20315() && (keyCode == 257 || keyCode == 335)) {
            this.sendMessage();
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = Math.max(0, this.totalHistoryHeight - this.visibleHistoryHeight);
        this.scrollAmount = class_3532.method_15350((double)(this.scrollAmount - verticalAmount * 10.0), (double)0.0, (double)maxScroll);
        return true;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 12, 0xFFFFFF);
        int chatAreaX = 20;
        int chatAreaY = 32;
        int chatAreaWidth = this.field_22789 - 40;
        int chatAreaHeight = this.field_22790 - chatAreaY - 40;
        context.method_51448().method_22903();
        context.method_44379(chatAreaX, chatAreaY, chatAreaX + chatAreaWidth, chatAreaY + chatAreaHeight);
        this.renderHistory(context);
        context.method_44380();
        context.method_51448().method_22909();
    }

    private void renderHistory(class_332 context) {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        PlayerAskHistoryComponent historyComponent = (PlayerAskHistoryComponent)ModComponents.PLAYER_ASK_HISTORY.get((Object)this.field_22787.field_1724);
        List<OpenAiApiDto.Message> history = historyComponent.getHistory();
        int y = 37 - (int)this.scrollAmount;
        int x = 25;
        int textWidth = this.field_22789 - 50;
        int totalHeight = 0;
        for (OpenAiApiDto.Message message : history) {
            if ("system".equals(message.role())) continue;
            class_5250 prefix = class_2561.method_43470((String)(message.role().equals("user") ? "\u0412\u044b: " : "AI: ")).method_27692(message.role().equals("user") ? class_124.field_1054 : class_124.field_1075);
            class_2561 content = AskChatScreen.parseFormattedText(message.content());
            class_5250 fullText = class_2561.method_43473().method_10852((class_2561)prefix).method_10852(content);
            List wrappedLines = this.field_22793.method_1728((class_5348)fullText, textWidth);
            for (class_5481 line : wrappedLines) {
                if (y >= 32 && y < this.field_22790 - 40) {
                    context.method_35720(this.field_22793, line, x, y, 0xFFFFFF);
                }
                y += 12;
                totalHeight += 12;
            }
            y += 6;
            totalHeight += 6;
        }
        this.totalHistoryHeight = totalHeight;
    }

    private static class_2561 parseFormattedText(String content) {
        class_5250 resultText = class_2561.method_43473();
        String[] parts = content.split("\\*\\*");
        for (int i = 0; i < parts.length; ++i) {
            if (i % 2 == 1) {
                resultText.method_10852((class_2561)class_2561.method_43470((String)parts[i]).method_27692(class_124.field_1067));
                continue;
            }
            resultText.method_10852((class_2561)class_2561.method_43470((String)parts[i]));
        }
        return resultText;
    }

    public boolean method_25421() {
        return false;
    }
}

