/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.gui;

import com.loracore.api.dto.OpenAiApiDto;
import com.loracore.component.ModComponents;
import com.loracore.component.PlayerDialogueComponent;
import com.loracore.component.PlayerQuestComponent;
import com.loracore.component.VillagerDataComponent;
import com.loracore.network.AcceptQuestC2SPacket;
import com.loracore.network.CompleteQuestC2SPacket;
import com.loracore.network.SendDialogueMessageC2SPacket;
import com.loracore.network.SetVillagerFrozenC2SPacket;
import com.loracore.quest.Quest;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1646;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class VillagerDialogueScreen
extends class_437 {
    private final class_1646 villager;
    private final VillagerDataComponent villagerData;
    private final PlayerDialogueComponent playerDialogue;
    private final PlayerQuestComponent playerQuest;
    private class_342 inputBox;
    private class_4185 sendButton;
    private class_4185 acceptQuestButton;
    private class_4185 declineQuestButton;
    private class_4185 completeQuestButton;

    public VillagerDialogueScreen(class_1646 villager) {
        super((class_2561)class_2561.method_43469((String)"gui.loracore.dialogue.title_prefix", (Object[])new Object[]{((VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)villager)).getVillagerName()}));
        this.villager = villager;
        this.villagerData = (VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)villager);
        this.playerDialogue = (PlayerDialogueComponent)ModComponents.PLAYER_DIALOGUE.get((Object)Objects.requireNonNull(class_310.method_1551().field_1724));
        this.playerQuest = (PlayerQuestComponent)ModComponents.PLAYER_QUEST.get((Object)Objects.requireNonNull(class_310.method_1551().field_1724));
    }

    protected void method_25426() {
        super.method_25426();
        this.inputBox = new class_342(this.field_22793, this.field_22789 / 2 - 150, this.field_22790 - 38, 240, 20, (class_2561)class_2561.method_43471((String)"gui.loracore.dialogue.input_placeholder"));
        this.inputBox.method_1880(256);
        this.method_37063((class_364)this.inputBox);
        this.sendButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.loracore.dialogue.button.send"), button -> this.sendMessage()).method_46434(this.field_22789 / 2 + 95, this.field_22790 - 38, 55, 20).method_46431();
        this.method_37063((class_364)this.sendButton);
        this.acceptQuestButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.loracore.quest.button.accept"), button -> {
            String langCode = class_310.method_1551().method_1526().method_4669();
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                ClientPlayNetworking.send((class_8710)new AcceptQuestC2SPacket(this.villager.method_5667(), langCode));
            }
        }).method_46434(this.field_22789 / 2 - 105, this.field_22790 - 38, 100, 20).method_46431();
        this.method_37063((class_364)this.acceptQuestButton);
        this.declineQuestButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.loracore.quest.button.decline"), button -> {
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                ClientPlayNetworking.send((class_8710)new SendDialogueMessageC2SPacket(this.villager.method_5667(), "\u042f, \u043f\u043e\u0436\u0430\u043b\u0443\u0439, \u043e\u0442\u043a\u0430\u0436\u0443\u0441\u044c.", "ru_ru"));
            }
        }).method_46434(this.field_22789 / 2 + 5, this.field_22790 - 38, 100, 20).method_46431();
        this.method_37063((class_364)this.declineQuestButton);
        this.completeQuestButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.loracore.quest.button.complete"), button -> ClientPlayNetworking.send((class_8710)new CompleteQuestC2SPacket(this.villager.method_5667()))).method_46434(this.field_22789 / 2 - 152, this.field_22790 - 38, 304, 20).method_46431();
        this.method_37063((class_364)this.completeQuestButton);
        ClientPlayNetworking.send((class_8710)new SetVillagerFrozenC2SPacket(this.villager.method_5667(), true));
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        Quest activeQuest = this.getActiveQuestForThisVillager();
        boolean hasOfferedQuest = this.villagerData.hasQuestForPlayer(this.field_22787.field_1724.method_5667());
        if (activeQuest != null) {
            boolean canComplete;
            this.completeQuestButton.field_22764 = canComplete = this.canCompleteQuest(activeQuest);
            this.completeQuestButton.field_22763 = canComplete;
            this.inputBox.field_22764 = !canComplete;
            this.sendButton.field_22764 = !canComplete;
            this.acceptQuestButton.field_22764 = false;
            this.declineQuestButton.field_22764 = false;
        } else if (hasOfferedQuest) {
            this.inputBox.field_22764 = false;
            this.sendButton.field_22764 = false;
            this.acceptQuestButton.field_22764 = true;
            this.acceptQuestButton.field_22763 = true;
            this.declineQuestButton.field_22764 = true;
            this.declineQuestButton.field_22763 = true;
            this.completeQuestButton.field_22764 = false;
        } else {
            this.inputBox.field_22764 = true;
            this.sendButton.field_22764 = true;
            this.acceptQuestButton.field_22764 = false;
            this.declineQuestButton.field_22764 = false;
            this.completeQuestButton.field_22764 = false;
        }
    }

    private Quest getActiveQuestForThisVillager() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return null;
        }
        return this.playerQuest.getQuests().stream().filter(quest -> quest.villagerGiverUuid().equals(this.villager.method_5667())).findFirst().orElse(null);
    }

    private boolean canCompleteQuest(Quest quest) {
        if (quest == null || this.field_22787 == null || this.field_22787.field_1724 == null) {
            return false;
        }
        return this.field_22787.field_1724.method_31548().method_18861(quest.goal().item()) >= quest.goal().requiredAmount();
    }

    public void method_25419() {
        ClientPlayNetworking.send((class_8710)new SetVillagerFrozenC2SPacket(this.villager.method_5667(), false));
        super.method_25419();
    }

    private void sendMessage() {
        String messageText = this.inputBox.method_1882();
        if (messageText == null || messageText.trim().isEmpty()) {
            return;
        }
        String langCode = class_310.method_1551().method_1526().method_4669();
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            ClientPlayNetworking.send((class_8710)new SendDialogueMessageC2SPacket(this.villager.method_5667(), messageText, langCode));
        }
        this.inputBox.method_1852("");
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.updateButtonVisibility();
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        List<OpenAiApiDto.Message> history = this.playerDialogue.getDialogueHistory(this.villager.method_5667());
        int y = 35;
        int maxTextWidth = this.field_22789 - 60;
        for (int i = 0; i < history.size(); ++i) {
            OpenAiApiDto.Message msg = history.get(i);
            if (msg.role().equals("system")) continue;
            class_5250 prefix = msg.role().equals("user") ? class_2561.method_43471((String)"gui.loracore.dialogue.prefix.user") : class_2561.method_43470((String)(this.villagerData.getVillagerName() + ": "));
            class_5250 fullText = class_2561.method_43473().method_10852((class_2561)prefix).method_27693(msg.content());
            List wrappedLines = this.field_22793.method_1728((class_5348)fullText, maxTextWidth);
            for (class_5481 line : wrappedLines) {
                context.method_35720(this.field_22793, line, 30, y, 0xFFFFFF);
                y += 12;
            }
        }
    }

    public boolean method_25421() {
        return false;
    }
}

