/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.service;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.loracore.LoraCoreMod;
import com.loracore.ModConfig;
import com.loracore.api.OpenAiApiClient;
import com.loracore.api.dto.OpenAiApiDto;
import com.loracore.component.ModComponents;
import com.loracore.component.VillagerDataComponent;
import com.loracore.service.RecipeService;
import com.loracore.util.PlayerContextProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1646;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3852;
import net.minecraft.class_7923;

public class AiService {
    private static final OpenAiApiClient apiClient = new OpenAiApiClient();
    private static final Gson GSON = new Gson();
    private static List<String> availableModels = new ArrayList<String>();
    private static final List<String> CRAFTING_KEYWORDS = List.of("\u0441\u043a\u0440\u0430\u0444\u0442\u0438\u0442\u044c", "\u0441\u0434\u0435\u043b\u0430\u0442\u044c", "\u0440\u0435\u0446\u0435\u043f\u0442", "\u043a\u0440\u0430\u0444\u0442", "craft", "make", "recipe");
    private static final String STATIC_SYSTEM_PROMPT = "\u0422\u044b - \u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a \u043f\u043e \u0438\u0433\u0440\u0435 Minecraft. \u0422\u0432\u043e\u0438 \u043e\u0442\u0432\u0435\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043f\u043e\u043b\u0435\u0437\u043d\u044b\u043c\u0438 \u0432 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0435 \u0438\u0433\u0440\u044b. \u0412 \u043a\u043e\u043d\u0446\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0442\u0435\u0431\u0435 \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0435\u0433\u043e \u0442\u0435\u043a\u0443\u0449\u0435\u043c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438 (\u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c, \u0431\u0438\u043e\u043c). \u0412\u0410\u0416\u041d\u041e: \u041e\u0441\u043d\u043e\u0432\u044b\u0432\u0430\u0439 \u0441\u0432\u043e\u0438 \u0441\u043e\u0432\u0435\u0442\u044b \u043d\u0430 \u044d\u0442\u043e\u0439 \u0410\u041a\u0422\u0423\u0410\u041b\u042c\u041d\u041e\u0419 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438, \u0430 \u043d\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0438\u0441\u0442\u043e\u0440\u0438\u0438 \u0434\u0438\u0430\u043b\u043e\u0433\u0430.";
    private static final Map<class_3852, List<String>> PROFESSION_GOAL_ITEMS = Map.ofEntries(Map.entry(class_3852.field_17056, List.of("minecraft:wheat_seeds", "minecraft:potato", "minecraft:carrot", "minecraft:beetroot_seeds", "minecraft:bone_meal")), Map.entry(class_3852.field_17057, List.of("minecraft:cod", "minecraft:salmon", "minecraft:string", "minecraft:stick")), Map.entry(class_3852.field_17063, List.of("minecraft:white_wool", "minecraft:black_wool", "minecraft:gray_wool", "minecraft:shears")), Map.entry(class_3852.field_17058, List.of("minecraft:feather", "minecraft:flint", "minecraft:stick", "minecraft:string")), Map.entry(class_3852.field_17060, List.of("minecraft:paper", "minecraft:book", "minecraft:ink_sac", "minecraft:feather")), Map.entry(class_3852.field_17054, List.of("minecraft:paper", "minecraft:compass", "minecraft:glass_pane")), Map.entry(class_3852.field_17055, List.of("minecraft:rotten_flesh", "minecraft:gold_ingot", "minecraft:redstone", "minecraft:glass_bottle")), Map.entry(class_3852.field_17052, List.of("minecraft:coal", "minecraft:iron_ingot", "minecraft:lava_bucket", "minecraft:diamond")), Map.entry(class_3852.field_17065, List.of("minecraft:coal", "minecraft:iron_ingot", "minecraft:flint", "minecraft:diamond")), Map.entry(class_3852.field_17064, List.of("minecraft:coal", "minecraft:iron_ingot", "minecraft:flint", "minecraft:diamond")), Map.entry(class_3852.field_17053, List.of("minecraft:raw_porkchop", "minecraft:raw_beef", "minecraft:raw_chicken", "minecraft:coal")), Map.entry(class_3852.field_17059, List.of("minecraft:leather", "minecraft:rabbit_hide", "minecraft:scute")), Map.entry(class_3852.field_17061, List.of("minecraft:clay_ball", "minecraft:stone", "minecraft:granite", "minecraft:diorite", "minecraft:andesite")), Map.entry(class_3852.field_17062, List.of("minecraft:dirt", "minecraft:poppy", "minecraft:dandelion")));
    private static final Map<class_3852, List<String>> PROFESSION_REWARD_ITEMS = Map.ofEntries(Map.entry(class_3852.field_17056, List.of("minecraft:bread", "minecraft:pumpkin_pie", "minecraft:cookie", "minecraft:emerald")), Map.entry(class_3852.field_17057, List.of("minecraft:cooked_cod", "minecraft:cooked_salmon", "minecraft:bucket", "minecraft:emerald")), Map.entry(class_3852.field_17063, List.of("minecraft:white_bed", "minecraft:painting", "minecraft:lead", "minecraft:emerald")), Map.entry(class_3852.field_17058, List.of("minecraft:arrow", "minecraft:spectral_arrow", "minecraft:bow", "minecraft:emerald")), Map.entry(class_3852.field_17060, List.of("minecraft:bookshelf", "minecraft:writable_book", "minecraft:glass", "minecraft:emerald")), Map.entry(class_3852.field_17054, List.of("minecraft:map", "minecraft:item_frame", "minecraft:emerald")), Map.entry(class_3852.field_17055, List.of("minecraft:lapis_lazuli", "minecraft:glowstone_dust", "minecraft:ender_pearl", "minecraft:emerald")), Map.entry(class_3852.field_17052, List.of("minecraft:iron_helmet", "minecraft:chainmail_chestplate", "minecraft:shield", "minecraft:emerald")), Map.entry(class_3852.field_17065, List.of("minecraft:iron_axe", "minecraft:iron_sword", "minecraft:bell", "minecraft:emerald")), Map.entry(class_3852.field_17064, List.of("minecraft:stone_axe", "minecraft:iron_hoe", "minecraft:diamond_pickaxe", "minecraft:emerald")), Map.entry(class_3852.field_17053, List.of("minecraft:cooked_porkchop", "minecraft:cooked_beef", "minecraft:rabbit_stew", "minecraft:emerald")), Map.entry(class_3852.field_17059, List.of("minecraft:leather_chestplate", "minecraft:saddle", "minecraft:item_frame", "minecraft:emerald")), Map.entry(class_3852.field_17061, List.of("minecraft:bricks", "minecraft:chiseled_stone_bricks", "minecraft:terracotta", "minecraft:emerald")), Map.entry(class_3852.field_17062, List.of("minecraft:emerald")));

    private static String cleanJsonString(String rawContent) {
        if (rawContent == null) {
            return "";
        }
        String cleaned = rawContent.trim();
        if (cleaned.startsWith("```json")) {
            cleaned = cleaned.substring(7);
        }
        if (cleaned.endsWith("```")) {
            cleaned = cleaned.substring(0, cleaned.length() - 3);
        }
        return cleaned.trim();
    }

    public static List<String> getAvailableModels() {
        return Collections.unmodifiableList(availableModels);
    }

    public static CompletableFuture<List<String>> fetchModels() {
        String apiKey = ModConfig.instance.API_KEY;
        String apiUrl = ModConfig.instance.API_URL;
        if (apiKey == null || apiKey.trim().isEmpty()) {
            return CompletableFuture.failedFuture(new IOException("API key is not configured"));
        }
        return apiClient.fetchModelsAsync(apiUrl, apiKey).thenApply(modelsResponse -> {
            if (modelsResponse == null || modelsResponse.data() == null) {
                return List.of();
            }
            List modelIds = modelsResponse.data().stream().map(OpenAiApiDto.ModelData::id).sorted().collect(Collectors.toList());
            availableModels = new ArrayList(modelIds);
            return modelIds;
        });
    }

    private static String getLanguageInstruction(String langCode) {
        String languageName = switch (langCode) {
            case "ru_ru" -> "\u0421\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u0440\u0443\u0441\u0441\u043a\u0438\u0439";
            case "rpr" -> "\u0414\u043e\u0440\u0435\u0444\u043e\u0440\u043c\u0435\u043d\u043d\u044b\u0439 \u0440\u0443\u0441\u0441\u043a\u0438\u0439 (\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439 \u0431\u0443\u043a\u0432\u0443 \u0463, \u0431\u0443\u043a\u0432\u0443 \u0456, \u0438 \u0442\u0432\u0435\u0440\u0434\u044b\u0439 \u0437\u043d\u0430\u043a\u044a \u043d\u0430 \u043a\u043e\u043d\u0446\u0435 \u0441\u043b\u043e\u0432\u044a \u043f\u043e\u0441\u043b\u0435 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u044b\u0445\u044a)";
            default -> "English (US)";
        };
        return "\u0422\u0432\u043e\u0439 \u043e\u0442\u0432\u0435\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0430\u043f\u0438\u0441\u0430\u043d \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u043d\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u043c \u044f\u0437\u044b\u043a\u0435: " + languageName + ".";
    }

    public static CompletableFuture<String> getAnswer(class_3222 player, List<OpenAiApiDto.Message> history, String languageCode) {
        String apiKey = ModConfig.instance.API_KEY;
        String apiUrl = ModConfig.instance.API_URL;
        String modelId = ModConfig.instance.MODEL_ID;
        if (apiKey.trim().isEmpty()) {
            player.method_43496((class_2561)class_2561.method_43471((String)"error.loracore.api_key_missing").method_27692(class_124.field_1061));
            return CompletableFuture.failedFuture(new IOException("API key is not configured."));
        }
        if (history.isEmpty()) {
            return CompletableFuture.failedFuture(new IllegalStateException("Cannot get answer for empty history."));
        }
        OpenAiApiDto.Message lastUserMessage = history.get(history.size() - 1);
        List<OpenAiApiDto.Message> previousHistory = history.subList(0, history.size() - 1);
        String dynamicContext = PlayerContextProvider.getDynamicContextFor(player);
        boolean isCraftingQuestion = CRAFTING_KEYWORDS.stream().anyMatch(lastUserMessage.content().toLowerCase()::contains);
        if (isCraftingQuestion) {
            RecipeService.findRecipeFromQuery(lastUserMessage.content(), player).ifPresent(recipeInfo -> {});
        }
        String combinedLastMessageContent = lastUserMessage.content() + dynamicContext;
        OpenAiApiDto.Message combinedLastMessage = new OpenAiApiDto.Message("user", combinedLastMessageContent);
        ArrayList<OpenAiApiDto.Message> messagesForApi = new ArrayList<OpenAiApiDto.Message>();
        messagesForApi.add(new OpenAiApiDto.Message("system", "\u0422\u044b - \u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a \u043f\u043e \u0438\u0433\u0440\u0435 Minecraft. \u0422\u0432\u043e\u0438 \u043e\u0442\u0432\u0435\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043f\u043e\u043b\u0435\u0437\u043d\u044b\u043c\u0438 \u0432 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0435 \u0438\u0433\u0440\u044b. \u0412 \u043a\u043e\u043d\u0446\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0442\u0435\u0431\u0435 \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0435\u0433\u043e \u0442\u0435\u043a\u0443\u0449\u0435\u043c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438 (\u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c, \u0431\u0438\u043e\u043c). \u0412\u0410\u0416\u041d\u041e: \u041e\u0441\u043d\u043e\u0432\u044b\u0432\u0430\u0439 \u0441\u0432\u043e\u0438 \u0441\u043e\u0432\u0435\u0442\u044b \u043d\u0430 \u044d\u0442\u043e\u0439 \u0410\u041a\u0422\u0423\u0410\u041b\u042c\u041d\u041e\u0419 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438, \u0430 \u043d\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0438\u0441\u0442\u043e\u0440\u0438\u0438 \u0434\u0438\u0430\u043b\u043e\u0433\u0430. " + AiService.getLanguageInstruction(languageCode)));
        messagesForApi.addAll(previousHistory);
        messagesForApi.add(combinedLastMessage);
        OpenAiApiDto.ChatRequest chatRequest = new OpenAiApiDto.ChatRequest(modelId, messagesForApi, 1024);
        return apiClient.createChatCompletionAsync(apiUrl, apiKey, chatRequest).thenApply(response -> {
            if (response.choices() == null || response.choices().isEmpty()) {
                throw new CompletionException(new IOException("AI returned an empty or invalid choice list."));
            }
            return response.choices().get(0).message().content();
        });
    }

    public static CompletableFuture<OpenAiApiDto.GeneratedVillagerInfo> generateVillagerPersonality(class_1646 villager, String languageCode) {
        String apiKey = ModConfig.instance.API_KEY;
        String apiUrl = ModConfig.instance.API_URL;
        String modelId = ModConfig.instance.MODEL_ID;
        if (apiKey.trim().isEmpty()) {
            return CompletableFuture.failedFuture(new IOException("API key not set."));
        }
        String profession = class_7923.field_41195.method_10221((Object)villager.method_7231().method_16924()).toString();
        String biome = villager.method_37908().method_23753(villager.method_24515()).method_40230().map(k -> k.method_29177().toString()).orElse("unknown");
        String langInstruction = AiService.getLanguageInstruction(languageCode);
        String prompt = "%s\nYou are a scriptwriter for Minecraft. Create a short personality for a village NPC.\nProfession: %s. Biome: %s.\nInvent a simple, memorable name (1-2 words) and a brief personality description (1 sentence).\nThe name and personality MUST be written in the language specified in the first line of this prompt.\nReply ONLY in JSON format: { \"name\": \"Villager's Name\", \"personality\": \"Description of their personality.\" }\n".formatted(langInstruction, profession, biome);
        List<OpenAiApiDto.Message> messages = List.of(new OpenAiApiDto.Message("system", "You only reply in JSON format."), new OpenAiApiDto.Message("user", prompt));
        OpenAiApiDto.ChatRequest payload = new OpenAiApiDto.ChatRequest(modelId, messages, 150);
        return apiClient.createChatCompletionAsync(apiUrl, apiKey, payload).thenApply(response -> {
            try {
                OpenAiApiDto.GeneratedVillagerInfo info;
                String rawContent = response.choices().getFirst().message().content();
                String cleanedJson = AiService.cleanJsonString(rawContent);
                if (cleanedJson.startsWith("{") && (info = (OpenAiApiDto.GeneratedVillagerInfo)GSON.fromJson(cleanedJson, OpenAiApiDto.GeneratedVillagerInfo.class)) != null && info.name() != null && !info.name().isBlank()) {
                    return info;
                }
                throw new JsonSyntaxException("Response is not a valid JSON object or is incomplete: " + rawContent);
            }
            catch (RuntimeException e) {
                throw new CompletionException(new RuntimeException("Failed to parse villager personality JSON from AI.", e));
            }
        });
    }

    public static CompletableFuture<OpenAiApiDto.GeneratedStructureInfo> generateStructureInfo(String structureType, String biomeId) {
        String apiKey = ModConfig.instance.API_KEY;
        String apiUrl = ModConfig.instance.API_URL;
        String modelId = ModConfig.instance.MODEL_ID;
        if (apiKey.trim().isEmpty()) {
            return CompletableFuture.failedFuture(new IOException("API key not set."));
        }
        String prompt = AiService.createStructurePrompt(structureType, biomeId);
        List<OpenAiApiDto.Message> messages = List.of(new OpenAiApiDto.Message("system", "You only reply in JSON format."), new OpenAiApiDto.Message("user", prompt));
        OpenAiApiDto.ChatRequest payload = new OpenAiApiDto.ChatRequest(modelId, messages, 100);
        return apiClient.createChatCompletionAsync(apiUrl, apiKey, payload).thenApply(response -> {
            if (response.choices() == null || response.choices().isEmpty()) {
                throw new RuntimeException("AI returned an empty or invalid choice list.");
            }
            String cleanedJson = AiService.cleanJsonString(response.choices().get(0).message().content());
            return AiService.parseGeneratedInfo(cleanedJson);
        });
    }

    public static CompletableFuture<OpenAiApiDto.GeneratedDialogueResponse> continueConversation(List<OpenAiApiDto.Message> history, String languageCode, class_1646 giver, class_3222 player) {
        String apiKey = ModConfig.instance.API_KEY;
        String apiUrl = ModConfig.instance.API_URL;
        String modelId = ModConfig.instance.MODEL_ID;
        VillagerDataComponent villagerData = (VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)giver);
        class_3852 profession = giver.method_7231().method_16924();
        List<String> goalItems = PROFESSION_GOAL_ITEMS.getOrDefault(profession, List.of("minecraft:cobblestone", "minecraft:stick"));
        List<String> rewardItems = PROFESSION_REWARD_ITEMS.getOrDefault(profession, List.of("minecraft:apple", "minecraft:emerald"));
        String langInstruction = AiService.getLanguageInstruction(languageCode);
        String villagerContext = "\u0422\u0432\u043e\u044f \u043b\u0438\u0447\u043d\u043e\u0441\u0442\u044c: " + villagerData.getVillagerName() + ", " + villagerData.getPersonality();
        String questContext = "";
        if (!villagerData.hasQuestForPlayer(player.method_5667())) {
            questContext = String.format("\u0422\u044b \u043c\u043e\u0436\u0435\u0448\u044c \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0438\u0442\u044c \u0438\u0433\u0440\u043e\u043a\u0443 \u043a\u0432\u0435\u0441\u0442. \u0415\u0441\u043b\u0438 \u041d\u0415 \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u0448\u044c, \u043f\u043e\u043b\u0435 \"quest\" \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c null.\n\u0415\u0441\u043b\u0438 \u041f\u0420\u0415\u0414\u041b\u0410\u0413\u0410\u0415\u0428\u042c, \u0437\u0430\u043f\u043e\u043b\u043d\u0438 \u043e\u0431\u044a\u0435\u043a\u0442 \"quest\". \u041f\u0440\u0430\u0432\u0438\u043b\u0430:\n- 'goalItem' \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430: [%s]. 'rewardItem' \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430: [%s].\n- 'goalAmount' \u043e\u0442 8 \u0434\u043e 32. 'rewardAmount' \u043e\u0442 1 \u0434\u043e 5.\n- 'title' \u0438 'description' \u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0435.\n- \u0412 'dialogue' \u043d\u0430\u043f\u0438\u0448\u0438 \u0440\u0435\u043f\u043b\u0438\u043a\u0443, \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u044e\u0449\u0443\u044e \u043a\u0432\u0435\u0441\u0442.\n", String.join((CharSequence)", ", goalItems), String.join((CharSequence)", ", rewardItems));
        }
        String systemPrompt = "%s\n%s\n\n\u0422\u0432\u043e\u044f \u0437\u0430\u0434\u0430\u0447\u0430 - \u0432\u0435\u0441\u0442\u0438 \u0434\u0438\u0430\u043b\u043e\u0433 \u043e\u0442 \u043b\u0438\u0446\u0430 NPC \u0438 \u043e\u0442\u0432\u0435\u0447\u0430\u0442\u044c \u0422\u041e\u041b\u042c\u041a\u041e \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 JSON \u043f\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0439 \u0441\u0445\u0435\u043c\u0435. \u041d\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0439 \u043d\u0438\u043a\u0430\u043a\u043e\u0433\u043e \u0442\u0435\u043a\u0441\u0442\u0430 \u043a\u0440\u043e\u043c\u0435 JSON.\n{\n  \"dialogue\": \"\u0422\u0432\u043e\u044f \u0440\u0435\u043f\u043b\u0438\u043a\u0430 \u0432 \u0434\u0438\u0430\u043b\u043e\u0433\u0435.\",\n  \"quest\": { ... } \u0438\u043b\u0438 null\n}\n\n%s\n".formatted(langInstruction, villagerContext, questContext);
        ArrayList<OpenAiApiDto.Message> messages = new ArrayList<OpenAiApiDto.Message>(history);
        messages.add(0, new OpenAiApiDto.Message("system", systemPrompt));
        OpenAiApiDto.ResponseFormat responseFormat = new OpenAiApiDto.ResponseFormat("json_object");
        OpenAiApiDto.ChatRequest payload = new OpenAiApiDto.ChatRequest(modelId, messages, 400, responseFormat);
        return apiClient.createChatCompletionAsync(apiUrl, apiKey, payload).thenApply(response -> {
            String rawContent = response.choices().getFirst().message().content();
            String cleanedJson = AiService.cleanJsonString(rawContent);
            try {
                OpenAiApiDto.GeneratedQuestInfo q;
                if (!cleanedJson.startsWith("{")) {
                    LoraCoreMod.LOGGER.warn("API \u043f\u0440\u043e\u0438\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u043b\u043e JSON-\u0440\u0435\u0436\u0438\u043c \u0438 \u0432\u0435\u0440\u043d\u0443\u043b\u043e \u0441\u0442\u0440\u043e\u043a\u0443. \u041e\u0442\u0432\u0435\u0442 \u0431\u0443\u0434\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d \u043a\u0430\u043a \u043f\u0440\u043e\u0441\u0442\u043e\u0439 \u0434\u0438\u0430\u043b\u043e\u0433.");
                    return new OpenAiApiDto.GeneratedDialogueResponse(cleanedJson, null);
                }
                OpenAiApiDto.GeneratedDialogueResponse dialogueResponse = (OpenAiApiDto.GeneratedDialogueResponse)GSON.fromJson(cleanedJson, OpenAiApiDto.GeneratedDialogueResponse.class);
                if (dialogueResponse == null || dialogueResponse.dialogue() == null) {
                    throw new JsonSyntaxException("\u041e\u0442\u0432\u0435\u0442 \u043e\u0442 AI \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044f 'dialogue'.");
                }
                if (!(dialogueResponse.quest() == null || (q = dialogueResponse.quest()).goalItem() != null && q.rewardItem() != null && goalItems.contains(q.goalItem()) && rewardItems.contains(q.rewardItem()))) {
                    LoraCoreMod.LOGGER.warn("AI \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043b \u043a\u0432\u0435\u0441\u0442 \u0441 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u043c\u0438 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430\u043c\u0438. \u041a\u0432\u0435\u0441\u0442 \u043e\u0442\u043c\u0435\u043d\u0435\u043d.");
                    return new OpenAiApiDto.GeneratedDialogueResponse(dialogueResponse.dialogue(), null);
                }
                return dialogueResponse;
            }
            catch (JsonSyntaxException e) {
                LoraCoreMod.LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u0434\u0438\u0430\u043b\u043e\u0433\u0430 \u043e\u0442 AI: {}. \u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435: {}", (Object)e.getMessage(), (Object)cleanedJson);
                return new OpenAiApiDto.GeneratedDialogueResponse("\u0418\u0437\u0432\u0438\u043d\u0438, \u044f \u0447\u0442\u043e-\u0442\u043e \u0437\u0430\u0434\u0443\u043c\u0430\u043b\u0441\u044f...", null);
            }
        });
    }

    private static String createStructurePrompt(String structureType, String biomeId) {
        String friendlyStructure = structureType.replace("minecraft:", "").replace("_", " ");
        String friendlyBiome = biomeId.replace("minecraft:", "").replace("_", " ");
        return "Generate a unique, short (1-3 words) name and a very brief (1 sentence) description for a structure of type '%s' in a '%s' biome.\nThe name should be in a fantasy/Minecraft style.\nThe language for the name and description MUST be the same as the user's language defined in the system message.\nReply ONLY in JSON format: { \"name\": \"The Name\", \"description\": \"A description.\" }\n".formatted(friendlyStructure, friendlyBiome);
    }

    private static OpenAiApiDto.GeneratedStructureInfo parseGeneratedInfo(String jsonContent) {
        try {
            OpenAiApiDto.GeneratedStructureInfo info = (OpenAiApiDto.GeneratedStructureInfo)GSON.fromJson(jsonContent, OpenAiApiDto.GeneratedStructureInfo.class);
            if (info == null || info.name() == null || info.name().trim().isEmpty()) {
                throw new JsonSyntaxException("Parsed info or name is null/empty.");
            }
            return info;
        }
        catch (JsonSyntaxException e) {
            LoraCoreMod.LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0430\u0440\u0441\u0438\u0442\u044c JSON \u043e\u0442\u0432\u0435\u0442\u0430 AI: {}", (Object)jsonContent, (Object)e);
            return new OpenAiApiDto.GeneratedStructureInfo("structure.loracore.unknown.name", "structure.loracore.unknown.description");
        }
    }
}

