/*
 * Decompiled with CFR 0.152.
 */
package com.loracore;

import com.loracore.LoraCoreMod;
import com.loracore.api.ClientApi;
import com.loracore.computer.ClientVFS;
import com.loracore.computer.ResourceLoader;
import com.loracore.computer.VirtualMachine;
import com.loracore.gui.AskChatScreen;
import com.loracore.gui.TabletScreen;
import com.loracore.keybinding.ModKeyBindings;
import com.loracore.network.BootTabletS2CPacket;
import com.loracore.network.vfs.VfsResponseS2CPacket;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_437;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class LoraCoreClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"loracore_CLIENT");
    private static boolean openAskScreenFlag = false;
    private static ClientVFS activeVfsInstance;
    private static TabletScreen activeTabletScreen;
    private static VirtualMachine activeVM;

    public void onInitializeClient() {
        LOGGER.info("LoraCore Client Initializing...");
        this.registerPacketHandlers();
        ModKeyBindings.register();
        this.registerClientCommands();
        this.registerTickEvents();
        ClientApi.renderThreadExecutor = arg_0 -> ((class_310)class_310.method_1551()).execute(arg_0);
        LOGGER.info("LoraCore Client successfully initialized!");
    }

    public static VirtualMachine getActiveVM() {
        return activeVM;
    }

    public static void shutdownActiveVM() {
        if (activeVM != null) {
            activeVM.shutdown();
            activeVM = null;
        }
        if (activeTabletScreen != null) {
            activeTabletScreen = null;
        }
        if (activeVfsInstance != null) {
            activeVfsInstance = null;
        }
    }

    public static void setActiveVfsInstance(ClientVFS vfs) {
        activeVfsInstance = vfs;
    }

    private void registerPacketHandlers() {
        ClientPlayNetworking.registerGlobalReceiver(VfsResponseS2CPacket.ID, (payload, context) -> context.client().execute(() -> {
            if (activeVM != null) {
                activeVM.resolveCallback(payload.callbackId(), payload.type(), payload.data());
            } else if (activeVfsInstance != null) {
                LuaBoolean responseValue = switch (payload.type()) {
                    case VfsResponseS2CPacket.ResponseType.TRUE -> LuaValue.TRUE;
                    case VfsResponseS2CPacket.ResponseType.FALSE -> LuaValue.FALSE;
                    case VfsResponseS2CPacket.ResponseType.STRING, VfsResponseS2CPacket.ResponseType.TABLE_JSON -> LuaValue.valueOf((String)payload.data());
                    default -> LuaValue.NIL;
                };
                activeVfsInstance.handleResponse(payload.callbackId(), (LuaValue)responseValue);
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(BootTabletS2CPacket.ID, (payload, context) -> {
            UUID fsUuid = payload.fileSystemUuid();
            String bootScriptPath = payload.bootScriptPath();
            String architecture = payload.architecture();
            int totalRamKb = payload.totalRamKb();
            context.client().execute(() -> {
                if (activeTabletScreen == null) {
                    LuaValue content;
                    ClientVFS vfs = new ClientVFS(fsUuid);
                    LoraCoreClient.setActiveVfsInstance(vfs);
                    activeTabletScreen = new TabletScreen(vfs);
                    ResourceLoader loader = path -> {
                        block8: {
                            String string;
                            block9: {
                                class_2960 id = path.contains(":") ? new class_2960(path) : new class_2960("loracore", path);
                                Optional resourceOpt = class_310.method_1551().method_1478().method_14486(id);
                                if (!resourceOpt.isPresent()) break block8;
                                InputStream stream = ((class_3298)resourceOpt.get()).method_14482();
                                try {
                                    string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                                    if (stream == null) break block9;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (stream != null) {
                                            try {
                                                stream.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (Exception e) {
                                        if (path.startsWith("/")) break block8;
                                        LoraCoreMod.LOGGER.error("Failed to load internal resource: {}", (Object)path, (Object)e);
                                    }
                                }
                                stream.close();
                            }
                            return string;
                        }
                        return null;
                    };
                    String bootScriptContent = bootScriptPath.startsWith("/") ? ((content = vfs.readBlocking(bootScriptPath)).isnil() ? null : content.tojstring()) : loader.load(bootScriptPath);
                    activeVM = new VirtualMachine(architecture, totalRamKb, activeTabletScreen, loader, vfs, fsUuid);
                    activeVM.start(bootScriptContent);
                }
                context.client().method_1507((class_437)activeTabletScreen);
            });
        });
    }

    private void registerClientCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ask").executes(context -> {
            openAskScreenFlag = true;
            return 1;
        })));
    }

    private void registerTickEvents() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (openAskScreenFlag) {
                openAskScreenFlag = false;
                client.method_1507((class_437)new AskChatScreen());
            }
        });
    }

    static {
        activeTabletScreen = null;
        activeVM = null;
    }
}

