/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.component;

import com.loracore.api.dto.OpenAiApiDto;
import com.loracore.component.PlayerDialogueComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class PlayerDialogueComponentImpl
implements PlayerDialogueComponent {
    private final Map<UUID, List<OpenAiApiDto.Message>> dialogueHistories = new ConcurrentHashMap<UUID, List<OpenAiApiDto.Message>>();

    @Override
    public List<OpenAiApiDto.Message> getDialogueHistory(UUID villagerUuid) {
        return this.dialogueHistories.computeIfAbsent(villagerUuid, k -> new ArrayList());
    }

    @Override
    public void addMessageToHistory(UUID villagerUuid, OpenAiApiDto.Message message) {
        this.getDialogueHistory(villagerUuid).add(message);
    }

    @Override
    public void initializeDialogue(UUID villagerUuid, String systemPrompt) {
        List<OpenAiApiDto.Message> history = this.getDialogueHistory(villagerUuid);
        if (history.isEmpty()) {
            history.add(new OpenAiApiDto.Message("system", systemPrompt));
        }
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 lookup) {
        this.dialogueHistories.clear();
        class_2487 historiesTag = tag.method_10562("DialogueHistories");
        for (String villagerUuidStr : historiesTag.method_10541()) {
            UUID villagerUuid = UUID.fromString(villagerUuidStr);
            class_2499 historyList = historiesTag.method_10554(villagerUuidStr, 10);
            ArrayList<OpenAiApiDto.Message> history = new ArrayList<OpenAiApiDto.Message>();
            for (class_2520 element : historyList) {
                class_2487 msgTag = (class_2487)element;
                history.add(new OpenAiApiDto.Message(msgTag.method_10558("role"), msgTag.method_10558("content")));
            }
            this.dialogueHistories.put(villagerUuid, history);
        }
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 lookup) {
        class_2487 historiesTag = new class_2487();
        for (Map.Entry<UUID, List<OpenAiApiDto.Message>> entry : this.dialogueHistories.entrySet()) {
            class_2499 historyList = new class_2499();
            for (OpenAiApiDto.Message msg : entry.getValue()) {
                class_2487 msgTag = new class_2487();
                msgTag.method_10582("role", msg.role());
                msgTag.method_10582("content", msg.content());
                historyList.add((Object)msgTag);
            }
            historiesTag.method_10566(entry.getKey().toString(), (class_2520)historyList);
        }
        tag.method_10566("DialogueHistories", (class_2520)historiesTag);
    }
}

