/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.component;

import com.loracore.component.VillagerDataComponent;
import com.loracore.quest.Quest;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class VillagerDataComponentImpl
implements VillagerDataComponent {
    private boolean hasGeneratedData = false;
    private String villagerName = "";
    private String personality = "";
    private final Map<UUID, Quest> assignedQuests = new ConcurrentHashMap<UUID, Quest>();
    private final Map<UUID, Integer> friendshipLevels = new ConcurrentHashMap<UUID, Integer>();

    @Override
    public boolean hasGeneratedData() {
        return this.hasGeneratedData;
    }

    @Override
    public void setHasGeneratedData(boolean hasGenerated) {
        this.hasGeneratedData = hasGenerated;
    }

    @Override
    public String getVillagerName() {
        return this.villagerName;
    }

    @Override
    public void setVillagerName(String name) {
        this.villagerName = name;
    }

    @Override
    public String getPersonality() {
        return this.personality;
    }

    @Override
    public void setPersonality(String personality) {
        this.personality = personality;
    }

    @Override
    public boolean hasQuestForPlayer(UUID playerUuid) {
        return this.assignedQuests.containsKey(playerUuid);
    }

    @Override
    public void assignQuestToPlayer(UUID playerUuid, Quest quest) {
        this.assignedQuests.put(playerUuid, quest);
    }

    @Override
    public void completeQuestForPlayer(UUID playerUuid) {
        this.assignedQuests.remove(playerUuid);
    }

    @Override
    public Quest getAssignedQuest(UUID playerUuid) {
        return this.assignedQuests.get(playerUuid);
    }

    @Override
    public int getFriendship(UUID playerUuid) {
        return this.friendshipLevels.getOrDefault(playerUuid, 0);
    }

    @Override
    public void setFriendship(UUID playerUuid, int level) {
        this.friendshipLevels.put(playerUuid, level);
    }

    @Override
    public void addFriendship(UUID playerUuid, int amount) {
        int currentFriendship = this.getFriendship(playerUuid);
        this.setFriendship(playerUuid, currentFriendship + amount);
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 lookup) {
        UUID playerUuid;
        this.hasGeneratedData = tag.method_10577("HasGeneratedData");
        this.villagerName = tag.method_10558("VillagerName");
        this.personality = tag.method_10558("Personality");
        this.assignedQuests.clear();
        if (tag.method_10573("AssignedQuests", 9)) {
            class_2499 questsList = tag.method_10554("AssignedQuests", 10);
            for (class_2520 element : questsList) {
                class_2487 questTag = (class_2487)element;
                playerUuid = questTag.method_25926("PlayerUUID");
                Quest quest = Quest.fromNbt(questTag.method_10562("QuestData"));
                this.assignedQuests.put(playerUuid, quest);
            }
        }
        this.friendshipLevels.clear();
        if (tag.method_10573("FriendshipLevels", 9)) {
            class_2499 friendshipList = tag.method_10554("FriendshipLevels", 10);
            for (class_2520 element : friendshipList) {
                class_2487 friendshipTag = (class_2487)element;
                playerUuid = friendshipTag.method_25926("PlayerUUID");
                int level = friendshipTag.method_10550("Level");
                this.friendshipLevels.put(playerUuid, level);
            }
        }
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 lookup) {
        tag.method_10556("HasGeneratedData", this.hasGeneratedData);
        tag.method_10582("VillagerName", this.villagerName);
        tag.method_10582("Personality", this.personality);
        if (this.assignedQuests != null && !this.assignedQuests.isEmpty()) {
            class_2499 questsList = new class_2499();
            for (Map.Entry<UUID, Object> entry : this.assignedQuests.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                class_2487 questTag = new class_2487();
                questTag.method_25927("PlayerUUID", entry.getKey());
                questTag.method_10566("QuestData", (class_2520)((Quest)entry.getValue()).writeNbt());
                questsList.add((Object)questTag);
            }
            tag.method_10566("AssignedQuests", (class_2520)questsList);
        }
        if (this.friendshipLevels != null && !this.friendshipLevels.isEmpty()) {
            class_2499 friendshipList = new class_2499();
            for (Map.Entry<UUID, Object> entry : this.friendshipLevels.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                class_2487 friendshipTag = new class_2487();
                friendshipTag.method_25927("PlayerUUID", entry.getKey());
                friendshipTag.method_10569("Level", ((Integer)entry.getValue()).intValue());
                friendshipList.add((Object)friendshipTag);
            }
            tag.method_10566("FriendshipLevels", (class_2520)friendshipList);
        }
    }
}

