/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.computer;

import com.loracore.LoraCoreMod;
import com.loracore.computer.IVfsRequester;
import com.loracore.network.vfs.VfsRequestC2SPacket;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_8710;
import org.luaj.vm2.LuaValue;

@Environment(value=EnvType.CLIENT)
public class ClientVFS
implements IVfsRequester {
    private final UUID fsUuid;
    private final ConcurrentHashMap<Integer, BlockingQueue<LuaValue>> responseQueues = new ConcurrentHashMap();
    private final AtomicInteger nextCallbackId = new AtomicInteger(0);

    public ClientVFS(UUID fsUuid) {
        this.fsUuid = fsUuid;
    }

    public UUID getFsUuid() {
        return this.fsUuid;
    }

    public void handleResponse(int callbackId, LuaValue response) {
        LoraCoreMod.LOGGER.info("[ClientVFS] Received response for callbackId={}, response={}", (Object)callbackId, (Object)response);
        if (this.responseQueues.containsKey(callbackId)) {
            this.responseQueues.get(callbackId).offer(response);
        }
    }

    @Override
    public void sendRequest(int callbackId, UUID fsUuid, VfsRequestC2SPacket.Operation op, String path, String content) {
        ClientPlayNetworking.send((class_8710)new VfsRequestC2SPacket(callbackId, fsUuid, op, path, content));
    }

    private int getNextCallbackId() {
        return this.nextCallbackId.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuaValue readBlocking(String path) {
        int callbackId = this.getNextCallbackId();
        this.responseQueues.put(callbackId, new LinkedBlockingQueue(1));
        this.sendRequest(callbackId, this.fsUuid, VfsRequestC2SPacket.Operation.READ, path, "");
        try {
            BlockingQueue<LuaValue> queue = this.responseQueues.get(callbackId);
            if (queue != null) {
                LuaValue response = queue.poll(10L, TimeUnit.SECONDS);
                LuaValue luaValue = response != null ? response : LuaValue.NIL;
                return luaValue;
            }
            LuaValue luaValue = LuaValue.NIL;
            return luaValue;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LuaValue luaValue = LuaValue.NIL;
            return luaValue;
        }
        finally {
            this.responseQueues.remove(callbackId);
        }
    }
}

