/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.computer;

import com.loracore.LoraCoreMod;
import com.loracore.api.ClientApi;
import com.loracore.computer.Terminal;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

public class LuaThreadRunner
implements Runnable {
    private final Globals globals;
    private final Terminal terminal;
    private final String bootScript;
    private final BlockingQueue<LuaValue[]> eventQueue = new LinkedBlockingQueue<LuaValue[]>();
    private Thread workerThread;
    private LuaThread kernelCoroutine;
    private final BlockingQueue<Resumable> resumeQueue = new LinkedBlockingQueue<Resumable>();

    public LuaThreadRunner(Globals globals, Terminal terminal, String bootScript) {
        this.globals = globals;
        this.terminal = terminal;
        this.bootScript = bootScript;
    }

    public Globals getGlobals() {
        return this.globals;
    }

    public void resumeWith(LuaThread coroutine, Varargs value) {
        try {
            this.resumeQueue.put(new Resumable(coroutine, value));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void start() {
        if (this.workerThread != null && this.workerThread.isAlive()) {
            return;
        }
        this.workerThread = new Thread((Runnable)this, "LoraCore-LuaVM");
        this.workerThread.setDaemon(true);
        this.workerThread.start();
    }

    public void stop() {
        if (this.workerThread != null && this.workerThread.isAlive()) {
            this.workerThread.interrupt();
            this.workerThread = null;
        }
    }

    public void pushEvent(LuaValue[] event) {
        if (this.workerThread == null || !this.workerThread.isAlive()) {
            return;
        }
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        LoraCoreMod.LOGGER.info("[LuaThreadRunner] Started thread loop.");
        try {
            LuaValue bootloader = this.globals.load(this.bootScript, "@boot.lua");
            this.kernelCoroutine = new LuaThread(this.globals, bootloader);
            Object resumeArgs = LuaValue.NIL;
            while (this.kernelCoroutine.state.status != 4 && !Thread.currentThread().isInterrupted()) {
                Resumable toResume = (Resumable)this.resumeQueue.poll();
                if (toResume != null) {
                    resumeArgs = toResume.value();
                } else {
                    LuaValue[] event = this.eventQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (Thread.currentThread().isInterrupted()) break;
                    toResume = (Resumable)this.resumeQueue.poll();
                    resumeArgs = toResume != null ? toResume.value() : (event != null ? LuaValue.varargsOf((LuaValue[])event) : LuaValue.NIL);
                }
                LoraCoreMod.LOGGER.info("[LuaThreadRunner] Resuming kernel with args: {}", resumeArgs);
                Varargs result = this.kernelCoroutine.resume((Varargs)resumeArgs);
                LoraCoreMod.LOGGER.info("[LuaThreadRunner] Kernel resumed with status: {}, result: {}", (Object)result.checkboolean(1), (Object)result);
                if (result.checkboolean(1)) continue;
                throw new LuaError(result.optjstring(2, "Kernel error"));
            }
            LoraCoreMod.LOGGER.info("[LuaThreadRunner] Thread loop finished.");
        }
        catch (InterruptedException e) {
            LoraCoreMod.LOGGER.info("Lua thread {} was interrupted.", (Object)Thread.currentThread().getName());
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            LoraCoreMod.LOGGER.error("!!! LUA VIRTUAL MACHINE KERNEL PANIC !!!", t);
            String causeMessage = t.getCause() != null ? t.getCause().getMessage() : "No root cause";
            String errorMessage = "LUA KERNEL PANIC:\n\n" + t.getMessage() + "\n\nCause: " + causeMessage;
            ClientApi.executeOnRenderThread(() -> this.terminal.showCrashScreen(errorMessage));
        }
    }

    private record Resumable(LuaThread coroutine, Varargs value) {
    }
}

