/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.computer;

import com.loracore.LoraCoreMod;
import com.loracore.computer.ResourceVFS;
import com.loracore.computer.WorldStorageVFS;
import com.loracore.network.vfs.VfsRequestC2SPacket;
import com.loracore.network.vfs.VfsResponseS2CPacket;
import java.nio.file.Path;
import java.util.UUID;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.luaj.vm2.LuaValue;

public class VirtualFileSystemManager {
    private static VirtualFileSystemManager INSTANCE;
    private class_3300 resourceManager;
    private Path worldSavePath;

    private VirtualFileSystemManager() {
    }

    public static synchronized VirtualFileSystemManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new VirtualFileSystemManager();
        }
        return INSTANCE;
    }

    public void initialize(MinecraftServer server) {
        this.worldSavePath = server.method_27050(class_5218.field_24188);
        LoraCoreMod.LOGGER.info("VirtualFileSystemManager initialized. World path: {}", (Object)this.worldSavePath);
    }

    public static void registerResourceManagerListener() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("loracore", "vfs_resource_listener");
            }

            public void method_14491(class_3300 manager) {
                VirtualFileSystemManager.getInstance().resourceManager = manager;
                LoraCoreMod.LOGGER.info("VFS ResourceManager has been reloaded.");
            }
        });
    }

    public VFSResponse performOperation(UUID fsUuid, VfsRequestC2SPacket.Operation op, String path, String content) {
        if (this.worldSavePath == null || this.resourceManager == null) {
            LoraCoreMod.LOGGER.error("VFS Manager not fully initialized! Cannot perform operations.");
            return new VFSResponse(VfsResponseS2CPacket.ResponseType.NIL, "");
        }
        WorldStorageVFS hdd = new WorldStorageVFS(this.worldSavePath, fsUuid);
        ResourceVFS rom = new ResourceVFS(this.resourceManager, "os");
        switch (op) {
            case EXISTS: {
                boolean exists = hdd.exists(path) || rom.exists(path);
                return new VFSResponse(exists ? VfsResponseS2CPacket.ResponseType.TRUE : VfsResponseS2CPacket.ResponseType.FALSE, "");
            }
            case READ: {
                LuaValue hddContent = hdd.read(path);
                if (!hddContent.isnil()) {
                    return new VFSResponse(VfsResponseS2CPacket.ResponseType.STRING, hddContent.tojstring());
                }
                LuaValue romContent = rom.read(path);
                if (!romContent.isnil()) {
                    return new VFSResponse(VfsResponseS2CPacket.ResponseType.STRING, romContent.tojstring());
                }
                return new VFSResponse(VfsResponseS2CPacket.ResponseType.NIL, "");
            }
            case ISDIR: {
                boolean isDir = hdd.isDirectory(path) || rom.isDirectory(path);
                return new VFSResponse(isDir ? VfsResponseS2CPacket.ResponseType.TRUE : VfsResponseS2CPacket.ResponseType.FALSE, "");
            }
            case WRITE: {
                boolean wrote = hdd.write(path, content);
                return new VFSResponse(wrote ? VfsResponseS2CPacket.ResponseType.TRUE : VfsResponseS2CPacket.ResponseType.FALSE, "");
            }
            case MAKEDIR: {
                boolean madeDir = hdd.makeDir(path);
                return new VFSResponse(madeDir ? VfsResponseS2CPacket.ResponseType.TRUE : VfsResponseS2CPacket.ResponseType.FALSE, "");
            }
            case LIST: {
                String listJson = hdd.list(path);
                if (listJson != null) {
                    return new VFSResponse(VfsResponseS2CPacket.ResponseType.TABLE_JSON, listJson);
                }
                String romListJson = rom.list(path);
                if (romListJson != null) {
                    return new VFSResponse(VfsResponseS2CPacket.ResponseType.TABLE_JSON, romListJson);
                }
                return new VFSResponse(VfsResponseS2CPacket.ResponseType.NIL, "");
            }
        }
        return new VFSResponse(VfsResponseS2CPacket.ResponseType.NIL, "");
    }

    public record VFSResponse(VfsResponseS2CPacket.ResponseType type, String data) {
    }
}

