/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.computer;

import com.loracore.LoraCoreMod;
import com.loracore.api.ClientApi;
import com.loracore.computer.IVfsRequester;
import com.loracore.computer.LuaThreadRunner;
import com.loracore.computer.ResourceLoader;
import com.loracore.computer.Terminal;
import com.loracore.computer.api.BiosAPI;
import com.loracore.computer.api.ColorsAPI;
import com.loracore.computer.api.FsAPI;
import com.loracore.computer.api.LuaApiHelper;
import com.loracore.computer.api.OsAPI;
import com.loracore.computer.device.CpuDevice;
import com.loracore.computer.device.GpuDevice;
import com.loracore.computer.device.RamDevice;
import com.loracore.computer.device.TerminalDevice;
import com.loracore.computer.device.ThreadDevice;
import com.loracore.network.vfs.VfsRequestC2SPacket;
import com.loracore.network.vfs.VfsResponseS2CPacket;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.jse.JsePlatform;

public class VirtualMachine {
    private final Terminal terminal;
    private final ResourceLoader resourceLoader;
    private final IVfsRequester vfsRequester;
    private final UUID fsUuid;
    private final List<Object> devices = new ArrayList<Object>();
    private final long startTime;
    private final Map<Integer, LuaThreadRunner> threads = new ConcurrentHashMap<Integer, LuaThreadRunner>();
    private static final int MAIN_THREAD_ID = 0;
    private final Map<Integer, LuaThread> waitingCoroutines = new ConcurrentHashMap<Integer, LuaThread>();
    private final AtomicInteger nextCallbackId = new AtomicInteger(1);

    public VirtualMachine(String architecture, int totalRamKb, Terminal terminal, ResourceLoader resourceLoader, IVfsRequester vfsRequester, UUID fsUuid) {
        this.terminal = terminal;
        this.resourceLoader = resourceLoader;
        this.vfsRequester = vfsRequester;
        this.fsUuid = fsUuid;
        this.startTime = System.nanoTime();
        this.devices.add(new ThreadDevice(this));
        this.devices.add(new CpuDevice(this, architecture));
        this.devices.add(new RamDevice(this, totalRamKb));
        this.devices.add(new TerminalDevice(terminal));
        this.devices.add(new GpuDevice(terminal));
    }

    private Globals createLuaGlobals() {
        Globals g = JsePlatform.standardGlobals();
        g.set("print", (LuaValue)new CustomPrint(this.terminal));
        g.load((LuaValue)new OsAPI(this));
        g.set("bios", (LuaValue)new BiosAPI(this));
        g.set("colors", (LuaValue)new ColorsAPI());
        if (this.vfsRequester != null) {
            g.set("fs", (LuaValue)new FsAPI(this, g));
        }
        LuaTable tabletApi = new LuaTable();
        for (Object device : this.devices) {
            LuaTable api = LuaApiHelper.createApi(device);
            String deviceName = device.getClass().getSimpleName().replace("Device", "").toLowerCase();
            tabletApi.set(deviceName, (LuaValue)api);
        }
        g.set("tablet", (LuaValue)tabletApi);
        return g;
    }

    public void start(String bootScriptContent) {
        if (bootScriptContent == null || bootScriptContent.isEmpty()) {
            LoraCoreMod.LOGGER.error("Boot script is empty!");
            this.terminal.showCrashScreen("FATAL: Boot script is empty or could not be loaded.");
            return;
        }
        this.startNewLuaThread(0, bootScriptContent);
    }

    public Varargs vfsRequest(LuaThread coroutine, VfsRequestC2SPacket.Operation op, Varargs args) {
        if (this.vfsRequester == null) {
            throw new LuaError("VFS is not available.");
        }
        int callbackId = this.nextCallbackId.getAndIncrement();
        this.waitingCoroutines.put(callbackId, coroutine);
        String path = args.checkjstring(1);
        String content = args.optjstring(2, "");
        LoraCoreMod.LOGGER.info("[VFS REQUEST] Preparing for Lua yield. CallbackID: {}, Operation: {}, Path: {}, FS_UUID: {}", new Object[]{callbackId, op, path, this.fsUuid});
        this.vfsRequester.sendRequest(callbackId, this.fsUuid, op, path, content);
        return LuaValue.NIL;
    }

    public void resolveCallback(int callbackId, VfsResponseS2CPacket.ResponseType type, String data) {
        LuaThread coroutine = this.waitingCoroutines.remove(callbackId);
        if (coroutine != null) {
            LuaBoolean responseValue = switch (type) {
                case VfsResponseS2CPacket.ResponseType.TRUE -> LuaValue.TRUE;
                case VfsResponseS2CPacket.ResponseType.FALSE -> LuaValue.FALSE;
                case VfsResponseS2CPacket.ResponseType.STRING, VfsResponseS2CPacket.ResponseType.TABLE_JSON -> LuaValue.valueOf((String)data);
                default -> LuaValue.NIL;
            };
            LuaThreadRunner runner = this.threads.get(0);
            if (runner != null) {
                LoraCoreMod.LOGGER.info("[VFS RESPONSE] Queuing coroutine for resumption. CallbackID: {}, Value: {}", (Object)callbackId, (Object)responseValue.tojstring());
                runner.resumeWith(coroutine, (Varargs)responseValue);
            }
        }
    }

    public boolean startNewLuaThread(int threadId, String code) {
        if (this.threads.containsKey(threadId)) {
            return false;
        }
        try {
            Globals threadGlobals = this.createLuaGlobals();
            LuaThreadRunner runner = new LuaThreadRunner(threadGlobals, this.terminal, code);
            this.threads.put(threadId, runner);
            runner.start();
            return true;
        }
        catch (Exception e) {
            LoraCoreMod.LOGGER.error("Failed to start Lua thread {}", (Object)threadId, (Object)e);
            return false;
        }
    }

    public void pushEventToThread(int threadId, LuaValue[] event) {
        LuaThreadRunner runner = this.threads.get(threadId);
        if (runner != null) {
            runner.pushEvent(event);
        }
    }

    public void pushEvent(Object ... args) {
        LuaValue[] event = new LuaValue[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object object;
            Objects.requireNonNull(args[i]);
            int n = 0;
            event[i] = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class, Double.class, Boolean.class}, (Object)object, n)) {
                case 0 -> {
                    String s = (String)object;
                    yield LuaValue.valueOf((String)s);
                }
                case 1 -> {
                    Integer num = (Integer)object;
                    yield LuaValue.valueOf((int)num);
                }
                case 2 -> {
                    Double num = (Double)object;
                    yield LuaValue.valueOf((double)num);
                }
                case 3 -> {
                    Boolean bool = (Boolean)object;
                    yield LuaValue.valueOf((boolean)bool);
                }
                default -> LuaValue.NIL;
            };
        }
        for (LuaThreadRunner runner : this.threads.values()) {
            runner.pushEvent(event);
        }
    }

    public void shutdown() {
        for (LuaThreadRunner runner : this.threads.values()) {
            runner.stop();
        }
        this.threads.clear();
    }

    public void reboot() {
        this.terminal.reboot();
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public double getUptime() {
        return (double)(System.nanoTime() - this.startTime) / 1.0E9;
    }

    public double getMemoryUsage() {
        LuaThreadRunner mainRunner = this.threads.get(0);
        if (mainRunner != null) {
            return mainRunner.getGlobals().get("collectgarbage").call("count").todouble();
        }
        return 0.0;
    }

    private static class CustomPrint
    extends OneArgFunction {
        private final Terminal term;

        public CustomPrint(Terminal term) {
            this.term = term;
        }

        public LuaValue call(LuaValue arg) {
            ClientApi.executeOnRenderThread(() -> this.term.print(arg.tojstring()));
            return LuaValue.NIL;
        }
    }
}

