/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.computer;

import com.google.gson.Gson;
import com.loracore.LoraCoreMod;
import com.loracore.computer.IFileSystem;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.luaj.vm2.LuaValue;

public class WorldStorageVFS
implements IFileSystem {
    private final Path rootDirectory;
    private final UUID fsUuid;
    private static final Gson GSON = new Gson();

    public WorldStorageVFS(Path worldRoot, UUID fsUuid) {
        this.rootDirectory = worldRoot.resolve("loracore_vfs");
        this.fsUuid = fsUuid;
    }

    private Path getDeviceRoot() {
        return this.rootDirectory.resolve(this.fsUuid.toString());
    }

    private Path getValidatedPath(String relativePath) throws IOException {
        String sanitizedRelativePath;
        Path deviceRoot = this.getDeviceRoot().normalize();
        Path targetPath = deviceRoot.resolve(sanitizedRelativePath = relativePath.startsWith("/") ? relativePath.substring(1) : relativePath).normalize();
        if (!targetPath.startsWith(deviceRoot)) {
            LoraCoreMod.LOGGER.warn("[VFS] Path traversal attempt! Base: [{}], Target: [{}]", (Object)deviceRoot, (Object)targetPath);
            throw new IOException("Path traversal attempt detected!");
        }
        return targetPath;
    }

    @Override
    public boolean exists(String path) {
        try {
            return Files.exists(this.getValidatedPath(path), new LinkOption[0]);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public LuaValue read(String path) {
        try {
            Path target = this.getValidatedPath(path);
            if (!Files.exists(target, new LinkOption[0]) || Files.isDirectory(target, new LinkOption[0])) {
                return LuaValue.NIL;
            }
            return LuaValue.valueOf((String)Files.readString(target, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            return LuaValue.NIL;
        }
    }

    @Override
    public boolean write(String path, String content) {
        try {
            Path target = this.getValidatedPath(path);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.writeString(target, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            LoraCoreMod.LOGGER.error("[VFS] Failed to write to {}: {}", (Object)path, (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public boolean makeDir(String path) {
        try {
            Files.createDirectories(this.getValidatedPath(path), new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            LoraCoreMod.LOGGER.error("[VFS] Failed to make dir {}: {}", (Object)path, (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public boolean isDirectory(String path) {
        try {
            return Files.isDirectory(this.getValidatedPath(path), new LinkOption[0]);
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String list(String path) {
        String string;
        block8: {
            Stream<Path> stream = Files.list(this.getValidatedPath(path));
            try {
                List fileNames = stream.map(p -> p.getFileName().toString()).collect(Collectors.toList());
                string = GSON.toJson(fileNames);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            stream.close();
        }
        return string;
    }
}

