/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.computer.api;

import com.loracore.computer.VirtualMachine;
import com.loracore.network.vfs.VfsRequestC2SPacket;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class FsAPI
extends LuaTable {
    public FsAPI(final VirtualMachine vm, final Globals g) {
        class VfsFunction
        extends VarArgFunction {
            private final VfsRequestC2SPacket.Operation op;

            VfsFunction(VfsRequestC2SPacket.Operation op) {
                this.op = op;
            }

            public Varargs invoke(Varargs args) {
                LuaThread coroutine = g.running;
                if (!coroutine.isthread()) {
                    VfsFunction.error((String)"VFS operations must be called from within a coroutine.");
                }
                return vm.vfsRequest(coroutine.checkthread(), this.op, args);
            }
        }
        this.set("exists", (LuaValue)new VfsFunction(VfsRequestC2SPacket.Operation.EXISTS));
        this.set("read", (LuaValue)new VfsFunction(VfsRequestC2SPacket.Operation.READ));
        this.set("write", (LuaValue)new VfsFunction(VfsRequestC2SPacket.Operation.WRITE));
        this.set("makeDir", (LuaValue)new VfsFunction(VfsRequestC2SPacket.Operation.MAKEDIR));
        this.set("isDir", (LuaValue)new VfsFunction(VfsRequestC2SPacket.Operation.ISDIR));
        this.set("list", (LuaValue)new VfsFunction(VfsRequestC2SPacket.Operation.LIST));
        this.set("combine", (LuaValue)new combine());
    }

    private static class combine
    extends TwoArgFunction {
        private combine() {
        }

        public LuaValue call(LuaValue p1, LuaValue p2) {
            String path1 = p1.checkjstring();
            String path2 = p2.checkjstring();
            if (path1.endsWith("/")) {
                return combine.valueOf((String)(path1 + path2));
            }
            return combine.valueOf((String)(path1 + "/" + path2));
        }
    }
}

