/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.computer.api;

import com.loracore.computer.api.Callback;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.VarArgFunction;

public class LuaApiHelper {
    public static LuaTable createApi(final Object device) {
        LuaTable api = new LuaTable();
        Map<String, Method> methods = LuaApiHelper.findCallbackMethods(device.getClass());
        for (Map.Entry<String, Method> entry : methods.entrySet()) {
            final String luaName = entry.getKey();
            final Method javaMethod = entry.getValue();
            api.set(luaName, (LuaValue)new VarArgFunction(){

                public Varargs invoke(Varargs args) {
                    try {
                        Object[] javaArgs = LuaApiHelper.convertLuaToJava(args, javaMethod.getParameters());
                        Object result = javaMethod.invoke(device, javaArgs);
                        return LuaApiHelper.convertJavaToLua(result);
                    }
                    catch (InvocationTargetException e) {
                        throw new LuaError(e.getTargetException());
                    }
                    catch (Exception e) {
                        throw new LuaError("Error calling method '" + luaName + "': " + e.getMessage());
                    }
                }
            });
        }
        return api;
    }

    private static Map<String, Method> findCallbackMethods(Class<?> clazz) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(Callback.class)) continue;
            Callback annotation = method.getAnnotation(Callback.class);
            String name = annotation.value().isEmpty() ? method.getName() : annotation.value();
            result.put(name, method);
        }
        return result;
    }

    private static Object[] convertLuaToJava(Varargs args, Parameter[] params) {
        Object[] result = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Class<?> type;
            result[i] = i >= args.narg() ? null : ((type = params[i].getType()) == Integer.TYPE || type == Integer.class ? Integer.valueOf(args.checkint(i + 1)) : (type == String.class ? args.checkjstring(i + 1) : (type == Boolean.TYPE || type == Boolean.class ? Boolean.valueOf(args.checkboolean(i + 1)) : (type == Double.TYPE || type == Double.class ? Double.valueOf(args.checkdouble(i + 1)) : args.checkuserdata(i + 1)))));
        }
        return result;
    }

    private static Varargs convertJavaToLua(Object obj) {
        if (obj == null) {
            return LuaValue.NIL;
        }
        if (obj instanceof Object[]) {
            Object[] objectArray = (Object[])obj;
            LuaValue[] values = new LuaValue[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                values[i] = LuaApiHelper.convertSingleJavaToLua(objectArray[i]);
            }
            return LuaValue.varargsOf((LuaValue[])values);
        }
        if (obj instanceof int[]) {
            int[] intArray = (int[])obj;
            LuaValue[] values = new LuaValue[intArray.length];
            for (int i = 0; i < intArray.length; ++i) {
                values[i] = LuaValue.valueOf((int)intArray[i]);
            }
            return LuaValue.varargsOf((LuaValue[])values);
        }
        return LuaApiHelper.convertSingleJavaToLua(obj);
    }

    private static LuaValue convertSingleJavaToLua(Object obj) {
        if (obj == null) {
            return LuaValue.NIL;
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            return LuaValue.valueOf((int)i);
        }
        if (obj instanceof String) {
            String s = (String)obj;
            return LuaValue.valueOf((String)s);
        }
        if (obj instanceof Boolean) {
            Boolean b = (Boolean)obj;
            return LuaValue.valueOf((boolean)b);
        }
        if (obj instanceof Double) {
            Double d = (Double)obj;
            return LuaValue.valueOf((double)d);
        }
        if (obj instanceof LuaValue) {
            LuaValue l = (LuaValue)obj;
            return l;
        }
        return LuaValue.userdataOf((Object)obj);
    }
}

