/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.computer.api;

import com.loracore.computer.VirtualMachine;
import java.util.Timer;
import java.util.TimerTask;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class OsAPI
extends LibFunction {
    private final VirtualMachine vm;
    private static final Timer timer = new Timer("LoraCore-LuaTimers", true);

    public OsAPI(VirtualMachine vm) {
        this.vm = vm;
    }

    public LuaValue call(LuaValue modname, LuaValue env) {
        LuaTable os = new LuaTable();
        os.set("reboot", (LuaValue)new reboot(this.vm));
        os.set("sleep", (LuaValue)new sleep(this.vm));
        env.set("os", (LuaValue)os);
        return os;
    }

    private static class reboot
    extends ZeroArgFunction {
        private final VirtualMachine vm;

        public reboot(VirtualMachine vm) {
            this.vm = vm;
        }

        public LuaValue call() {
            this.vm.reboot();
            return NIL;
        }
    }

    private static class sleep
    extends OneArgFunction {
        private final VirtualMachine vm;

        public sleep(VirtualMachine vm) {
            this.vm = vm;
        }

        public LuaValue call(LuaValue arg) {
            double seconds = arg.checkdouble();
            long millis = (long)(seconds * 1000.0);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    vm.pushEvent("timer");
                }
            }, millis);
            return NIL;
        }
    }

    private static class pullEvent
    extends VarArgFunction {
        private final VirtualMachine vm;

        public pullEvent(VirtualMachine vm) {
            this.vm = vm;
        }

        public Varargs invoke(Varargs args) {
            return LuaValue.varargsOf((LuaValue[])new LuaValue[]{LuaValue.valueOf((String)"yield_placeholder")});
        }
    }
}

