/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.computer.device;

import com.loracore.api.ClientApi;
import com.loracore.computer.Terminal;
import com.loracore.computer.api.Callback;

public class TerminalDevice {
    private final Terminal terminal;

    public TerminalDevice(Terminal terminal) {
        this.terminal = terminal;
    }

    @Callback(value="write", doc="Writes text to the current cursor position.")
    public void write(String text) {
        ClientApi.executeOnRenderThread(() -> this.terminal.print(text));
    }

    @Callback(doc="Clears the entire terminal screen.")
    public void clear() {
        ClientApi.executeOnRenderThread(this.terminal::clear);
    }

    @Callback(doc="Clears the line the cursor is currently on.")
    public void clearLine() {
        ClientApi.executeOnRenderThread(this.terminal::clearLine);
    }

    @Callback(doc="Sets the cursor's position. Top-left is (1, 1).")
    public void setCursorPos(int x, int y) {
        ClientApi.executeOnRenderThread(() -> this.terminal.setCursorPos(x, y));
    }

    @Callback(doc="Enables or disables the cursor's blinking.")
    public void setCursorBlink(boolean enabled) {
        ClientApi.executeOnRenderThread(() -> this.terminal.setCursorBlink(enabled));
    }

    @Callback(doc="Sets the foreground color for subsequent text.")
    public void setTextColor(int color) {
        ClientApi.executeOnRenderThread(() -> this.terminal.setTextColor(color));
    }

    @Callback(doc="Sets the background color for subsequent text.")
    public void setBackgroundColor(int color) {
        ClientApi.executeOnRenderThread(() -> this.terminal.setBackgroundColor(color));
    }

    @Callback(value="getCursorPos", doc="Returns the current cursor position as (x, y).")
    public int[] getCursorPosition() {
        return this.terminal.getCursorPos();
    }

    @Callback(value="getSize", doc="Returns the terminal's size in characters as (width, height).")
    public int[] getTerminalSize() {
        return this.terminal.getSize();
    }

    @Callback(doc="Reads a line of input from the user, waiting for Enter.")
    public String read() {
        return this.terminal.read();
    }
}

