/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.computer.device;

import com.loracore.computer.VirtualMachine;
import com.loracore.computer.api.Callback;
import java.util.concurrent.atomic.AtomicInteger;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

public class ThreadDevice {
    private final VirtualMachine vm;
    private final AtomicInteger nextThreadId = new AtomicInteger(1);

    public ThreadDevice(VirtualMachine vm) {
        this.vm = vm;
    }

    @Callback(value="create", doc="Creates and starts a new Lua thread from a code string.")
    public Object[] create(String code) {
        int threadId = this.nextThreadId.getAndIncrement();
        boolean success = this.vm.startNewLuaThread(threadId, code);
        if (success) {
            return new Object[]{threadId};
        }
        return new Object[]{null, "Failed to create thread."};
    }

    @Callback(value="send", doc="Sends a message to a specific thread.")
    public void send(int threadId, Varargs args) {
        LuaValue[] message = new LuaValue[args.narg() + 1];
        message[0] = LuaValue.valueOf((String)"message");
        for (int i = 1; i <= args.narg(); ++i) {
            message[i] = args.arg(i);
        }
        this.vm.pushEventToThread(threadId, message);
    }
}

