/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.gui;

import com.loracore.LoraCoreClient;
import com.loracore.computer.ClientVFS;
import com.loracore.computer.Terminal;
import com.loracore.computer.VirtualMachine;
import com.loracore.gui.CrashScreen;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class TabletScreen
extends class_437
implements Terminal {
    private static final int BACKGROUND_OVERLAY_COLOR = -1342177280;
    private static final int TABLET_BG_COLOR = -14803426;
    private static final int TABLET_BORDER_COLOR = -16119286;
    private static final int TEXT_COLOR = -2039584;
    private static final int FONT_HEIGHT = 9;
    private static final int FONT_WIDTH = 6;
    private final VirtualMachine vm;
    private TerminalChar[][] buffer;
    private int termWidth;
    private int termHeight;
    private int cursorX = 1;
    private int cursorY = 1;
    private boolean cursorVisible = true;
    private boolean cursorBlinkEnabled = true;
    private int tickCounter = 0;
    private int tabletX;
    private int tabletY;
    private int tabletWidth;
    private int tabletHeight;
    private int currentTextColor = -2039584;
    private int currentBgColor = -14803426;
    private final BlockingQueue<String> inputQueue = new LinkedBlockingQueue<String>(1);
    private String currentInputLine = "";
    private final ClientVFS vfs;

    public TabletScreen(ClientVFS vfs) {
        super((class_2561)class_2561.method_43470((String)"LoraOS"));
        this.vfs = vfs;
        this.vm = LoraCoreClient.getActiveVM();
    }

    protected void method_25426() {
        super.method_25426();
        this.calculateTabletDimensions();
        int newTermWidth = (this.tabletWidth - 8) / 6;
        int newTermHeight = (this.tabletHeight - 8) / 9;
        if (this.buffer == null || this.termWidth != newTermWidth || this.termHeight != newTermHeight) {
            this.termWidth = newTermWidth;
            this.termHeight = newTermHeight;
            this.buffer = new TerminalChar[this.termHeight][this.termWidth];
            for (int y = 0; y < this.termHeight; ++y) {
                for (int x = 0; x < this.termWidth; ++x) {
                    this.buffer[y][x] = new TerminalChar(' ', this.currentTextColor, this.currentBgColor);
                }
            }
            if (this.vm != null) {
                this.vm.pushEvent("term_resize");
            }
        }
    }

    public void method_25419() {
        super.method_25419();
    }

    public void method_25432() {
        LoraCoreClient.shutdownActiveVM();
        super.method_25432();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        if (this.cursorBlinkEnabled) {
            ++this.tickCounter;
            if (this.tickCounter >= 10) {
                this.tickCounter = 0;
                this.cursorVisible = !this.cursorVisible;
            }
        } else {
            this.cursorVisible = true;
        }
        context.method_25294(this.tabletX, this.tabletY, this.tabletX + this.tabletWidth, this.tabletY + this.tabletHeight, -16119286);
        if (this.buffer != null) {
            for (int y = 0; y < this.termHeight; ++y) {
                for (int x = 0; x < this.termWidth; ++x) {
                    TerminalChar ch = this.buffer[y][x];
                    int drawX = this.tabletX + 4 + x * 6;
                    int drawY = this.tabletY + 4 + y * 9;
                    context.method_25294(drawX, drawY, drawX + 6, drawY + 9, ch.bgColor);
                    context.method_25303(this.field_22793, String.valueOf(ch.character), drawX, drawY, ch.fgColor);
                }
            }
        }
        if (this.cursorVisible) {
            int cursorDrawX = this.tabletX + 4 + (this.cursorX - 1) * 6;
            int cursorDrawY = this.tabletY + 4 + (this.cursorY - 1) * 9;
            context.method_25294(cursorDrawX, cursorDrawY, cursorDrawX + 6, cursorDrawY + 9, -1);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (modifiers == 2 && keyCode == 67) {
            if (this.vm != null) {
                this.vm.pushEvent("signal", "interrupt");
            }
            return true;
        }
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            try {
                this.inputQueue.put(this.currentInputLine);
                this.print("\n");
                this.currentInputLine = "";
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
        if (keyCode == 259) {
            if (!this.currentInputLine.isEmpty()) {
                this.currentInputLine = this.currentInputLine.substring(0, this.currentInputLine.length() - 1);
                if (this.cursorX > 1) {
                    this.setCursorPos(this.cursorX - 1, this.cursorY);
                    this.print(" ");
                    this.setCursorPos(this.cursorX - 1, this.cursorY);
                }
            }
            return true;
        }
        if (this.vm != null) {
            this.vm.pushEvent("key", keyCode);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        this.currentInputLine = this.currentInputLine + chr;
        this.print(String.valueOf(chr));
        return true;
    }

    @Override
    public void print(String text) {
        for (char ch : text.toCharArray()) {
            if (ch == '\n') {
                this.cursorX = 1;
                ++this.cursorY;
                continue;
            }
            if (this.cursorX > this.termWidth) {
                this.cursorX = 1;
                ++this.cursorY;
            }
            if (this.cursorY > this.termHeight) {
                this.scrollBuffer();
                this.cursorY = this.termHeight;
            }
            if (this.buffer == null || this.cursorY - 1 < 0 || this.cursorY - 1 >= this.buffer.length || this.cursorX - 1 < 0 || this.cursorX - 1 >= this.buffer[0].length) continue;
            this.buffer[this.cursorY - 1][this.cursorX - 1].setCharacter(ch, this.currentTextColor, this.currentBgColor);
            ++this.cursorX;
        }
        this.resetCursorBlink();
    }

    @Override
    public void clear() {
        if (this.buffer != null) {
            for (int y = 0; y < this.termHeight; ++y) {
                for (int x = 0; x < this.termWidth; ++x) {
                    this.buffer[y][x].setCharacter(' ', this.currentTextColor, this.currentBgColor);
                }
            }
        }
        this.cursorX = 1;
        this.cursorY = 1;
        this.resetCursorBlink();
    }

    @Override
    public void clearLine() {
        if (this.buffer != null && this.cursorY - 1 >= 0 && this.cursorY - 1 < this.buffer.length) {
            for (int x = 0; x < this.termWidth; ++x) {
                this.buffer[this.cursorY - 1][x].setCharacter(' ', this.currentTextColor, this.currentBgColor);
            }
        }
        this.resetCursorBlink();
    }

    @Override
    public void setCursorPos(int x, int y) {
        this.cursorX = Math.max(1, Math.min(this.termWidth + 1, x));
        this.cursorY = Math.max(1, Math.min(this.termHeight, y));
        this.resetCursorBlink();
    }

    @Override
    public String read() {
        try {
            return this.inputQueue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    @Override
    public void reboot() {
        if (this.field_22787 != null) {
            this.field_22787.execute(() -> {
                LoraCoreClient.shutdownActiveVM();
                this.field_22787.method_1507(null);
            });
        }
    }

    @Override
    public void setTextColor(int color) {
        this.currentTextColor = 0xFF000000 | color;
    }

    @Override
    public void setBackgroundColor(int color) {
        this.currentBgColor = 0xFF000000 | color;
    }

    @Override
    public int[] getCursorPos() {
        return new int[]{this.cursorX, this.cursorY};
    }

    @Override
    public int[] getSize() {
        return new int[]{this.termWidth, this.termHeight};
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -1342177280);
    }

    public boolean method_25421() {
        return false;
    }

    private void calculateTabletDimensions() {
        this.tabletHeight = (int)((double)this.field_22790 * 0.9);
        this.tabletWidth = (int)((double)this.tabletHeight * 1.6);
        if ((double)this.tabletWidth > (double)this.field_22789 * 0.95) {
            this.tabletWidth = (int)((double)this.field_22789 * 0.95);
            this.tabletHeight = (int)((double)this.tabletWidth * 0.625);
        }
        this.tabletX = (this.field_22789 - this.tabletWidth) / 2;
        this.tabletY = (this.field_22790 - this.tabletHeight) / 2;
    }

    private void scrollBuffer() {
        if (this.buffer == null) {
            return;
        }
        for (int y = 0; y < this.termHeight - 1; ++y) {
            if (this.buffer[y] == null || this.buffer[y + 1] == null) continue;
            System.arraycopy(this.buffer[y + 1], 0, this.buffer[y], 0, this.termWidth);
        }
        for (int x = 0; x < this.termWidth; ++x) {
            if (this.buffer[this.termHeight - 1] == null) continue;
            this.buffer[this.termHeight - 1][x] = new TerminalChar(' ', this.currentTextColor, this.currentBgColor);
        }
    }

    private void resetCursorBlink() {
        this.cursorVisible = true;
        this.tickCounter = 0;
    }

    @Override
    public void setCursorBlink(boolean enabled) {
        this.cursorBlinkEnabled = enabled;
        if (!enabled) {
            this.cursorVisible = true;
        }
    }

    @Override
    public void showCrashScreen(String message) {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new CrashScreen(message, this));
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class TerminalChar {
        char character;
        int fgColor;
        int bgColor;

        TerminalChar(char character, int fgColor, int bgColor) {
            this.character = character;
            this.fgColor = fgColor;
            this.bgColor = bgColor;
        }

        void setCharacter(char c, int fg, int bg) {
            this.character = c;
            this.fgColor = fg;
            this.bgColor = bg;
        }
    }
}

