/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.gui;

import com.loracore.api.dto.OpenAiApiDto;
import com.loracore.component.ModComponents;
import com.loracore.component.PlayerDialogueComponent;
import com.loracore.component.PlayerQuestComponent;
import com.loracore.component.VillagerDataComponent;
import com.loracore.network.AcceptQuestC2SPacket;
import com.loracore.network.CompleteQuestC2SPacket;
import com.loracore.network.GiveGiftC2SPacket;
import com.loracore.network.SendDialogueMessageC2SPacket;
import com.loracore.network.SetVillagerFrozenC2SPacket;
import com.loracore.quest.Quest;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1646;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class VillagerDialogueScreen
extends class_437 {
    private final class_1646 villager;
    private final VillagerDataComponent villagerData;
    private final PlayerDialogueComponent playerDialogue;
    private final PlayerQuestComponent playerQuest;
    private double scrollAmount;
    private int visibleHistoryHeight;
    private int totalHistoryHeight;
    private class_342 inputBox;
    private class_4185 sendButton;
    private class_4185 giveGiftButton;
    private class_4185 acceptQuestButton;
    private class_4185 declineQuestButton;
    private class_4185 completeQuestButton;

    public VillagerDialogueScreen(class_1646 villager) {
        super((class_2561)class_2561.method_43469((String)"gui.loracore.dialogue.title_prefix", (Object[])new Object[]{((VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)villager)).getVillagerName()}));
        this.villager = villager;
        this.villagerData = (VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)villager);
        this.playerDialogue = (PlayerDialogueComponent)ModComponents.PLAYER_DIALOGUE.get((Object)Objects.requireNonNull(class_310.method_1551().field_1724));
        this.playerQuest = (PlayerQuestComponent)ModComponents.PLAYER_QUEST.get((Object)Objects.requireNonNull(class_310.method_1551().field_1724));
    }

    protected void method_25426() {
        super.method_25426();
        int chatAreaY = 35;
        int chatAreaBottomMargin = 45;
        this.visibleHistoryHeight = this.field_22790 - 35 - 45;
        this.inputBox = new class_342(this.field_22793, this.field_22789 / 2 - 150, this.field_22790 - 38, 180, 20, (class_2561)class_2561.method_43471((String)"gui.loracore.dialogue.input_placeholder"));
        this.inputBox.method_1880(256);
        this.method_37063((class_364)this.inputBox);
        this.giveGiftButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.loracore.dialogue.button.give_gift"), button -> {
            if (this.field_22787 != null) {
                ClientPlayNetworking.send((class_8710)new GiveGiftC2SPacket(this.villager.method_5667()));
            }
        }).method_46434(this.field_22789 / 2 + 35, this.field_22790 - 38, 55, 20).method_46431();
        this.method_37063((class_364)this.giveGiftButton);
        this.sendButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.loracore.dialogue.button.send"), button -> this.sendMessage()).method_46434(this.field_22789 / 2 + 95, this.field_22790 - 38, 55, 20).method_46431();
        this.method_37063((class_364)this.sendButton);
        this.acceptQuestButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.loracore.quest.button.accept"), button -> {
            String langCode = class_310.method_1551().method_1526().method_4669();
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                ClientPlayNetworking.send((class_8710)new AcceptQuestC2SPacket(this.villager.method_5667(), langCode));
            }
        }).method_46434(this.field_22789 / 2 - 105, this.field_22790 - 38, 100, 20).method_46431();
        this.method_37063((class_364)this.acceptQuestButton);
        this.declineQuestButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.loracore.quest.button.decline"), button -> {
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                ClientPlayNetworking.send((class_8710)new SendDialogueMessageC2SPacket(this.villager.method_5667(), "\u042f, \u043f\u043e\u0436\u0430\u043b\u0443\u0439, \u043e\u0442\u043a\u0430\u0436\u0443\u0441\u044c.", "ru_ru"));
            }
        }).method_46434(this.field_22789 / 2 + 5, this.field_22790 - 38, 100, 20).method_46431();
        this.method_37063((class_364)this.declineQuestButton);
        this.completeQuestButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.loracore.quest.button.complete"), button -> ClientPlayNetworking.send((class_8710)new CompleteQuestC2SPacket(this.villager.method_5667()))).method_46434(this.field_22789 / 2 - 152, this.field_22790 - 38, 304, 20).method_46431();
        this.method_37063((class_364)this.completeQuestButton);
        ClientPlayNetworking.send((class_8710)new SetVillagerFrozenC2SPacket(this.villager.method_5667(), true));
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        boolean isHoldingItem;
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        Quest activeQuest = this.getActiveQuestForThisVillager();
        boolean hasOfferedQuest = this.villagerData.hasQuestForPlayer(this.field_22787.field_1724.method_5667());
        this.giveGiftButton.field_22763 = isHoldingItem = !this.field_22787.field_1724.method_6047().method_7960();
        if (activeQuest != null) {
            boolean canComplete;
            this.completeQuestButton.field_22764 = canComplete = this.canCompleteQuest(activeQuest);
            this.completeQuestButton.field_22763 = canComplete;
            this.inputBox.field_22764 = !canComplete;
            this.sendButton.field_22764 = !canComplete;
            this.giveGiftButton.field_22764 = !canComplete;
            this.acceptQuestButton.field_22764 = false;
            this.declineQuestButton.field_22764 = false;
        } else if (hasOfferedQuest) {
            this.inputBox.field_22764 = false;
            this.sendButton.field_22764 = false;
            this.giveGiftButton.field_22764 = false;
            this.acceptQuestButton.field_22764 = true;
            this.acceptQuestButton.field_22763 = true;
            this.declineQuestButton.field_22764 = true;
            this.declineQuestButton.field_22763 = true;
            this.completeQuestButton.field_22764 = false;
        } else {
            this.inputBox.field_22764 = true;
            this.sendButton.field_22764 = true;
            this.giveGiftButton.field_22764 = true;
            this.acceptQuestButton.field_22764 = false;
            this.declineQuestButton.field_22764 = false;
            this.completeQuestButton.field_22764 = false;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.updateButtonVisibility();
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            int friendshipLevel = this.villagerData.getFriendship(this.field_22787.field_1724.method_5667());
            class_5250 friendshipText = class_2561.method_43469((String)"gui.loracore.dialogue.friendship", (Object[])new Object[]{friendshipLevel}).method_27692(class_124.field_1075);
            int textWidth = this.field_22793.method_27525((class_5348)friendshipText);
            context.method_27535(this.field_22793, (class_2561)friendshipText, this.field_22789 - textWidth - 30, 25, 0xFFFFFF);
        }
        int chatAreaX = 30;
        int chatAreaY = 35;
        int chatAreaWidth = this.field_22789 - 60;
        int chatAreaHeight = this.visibleHistoryHeight + 5;
        context.method_51448().method_22903();
        context.method_44379(30, 35, 30 + chatAreaWidth, 35 + chatAreaHeight);
        List<OpenAiApiDto.Message> history = this.playerDialogue.getDialogueHistory(this.villager.method_5667());
        int y = 35 - (int)this.scrollAmount;
        int currentTotalHeight = 0;
        for (OpenAiApiDto.Message msg : history) {
            if ("system".equals(msg.role())) {
                class_5250 systemText = class_2561.method_43471((String)msg.content()).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
                context.method_27534(this.field_22793, (class_2561)systemText, this.field_22789 / 2, y, 0xFFFFFF);
                y += 12;
                currentTotalHeight += 12;
                continue;
            }
            class_5250 prefix = msg.role().equals("user") ? class_2561.method_43471((String)"gui.loracore.dialogue.prefix.user") : class_2561.method_43470((String)(this.villagerData.getVillagerName() + ": "));
            class_5250 fullText = class_2561.method_43473().method_10852((class_2561)prefix).method_27693(msg.content());
            List wrappedLines = this.field_22793.method_1728((class_5348)fullText, chatAreaWidth);
            for (class_5481 line : wrappedLines) {
                if (y >= 25 && y < 35 + chatAreaHeight) {
                    context.method_35720(this.field_22793, line, 30, y, 0xFFFFFF);
                }
                y += 12;
                currentTotalHeight += 12;
            }
            y += 8;
            currentTotalHeight += 8;
        }
        this.totalHistoryHeight = currentTotalHeight;
        context.method_44380();
        context.method_51448().method_22909();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.inputBox.method_20315() && (keyCode == 257 || keyCode == 335)) {
            this.sendMessage();
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = Math.max(0, this.totalHistoryHeight - this.visibleHistoryHeight);
        this.scrollAmount = class_3532.method_15350((double)(this.scrollAmount - verticalAmount * 10.0), (double)0.0, (double)maxScroll);
        return true;
    }

    private Quest getActiveQuestForThisVillager() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return null;
        }
        return this.playerQuest.getQuests().stream().filter(quest -> quest.villagerGiverUuid().equals(this.villager.method_5667())).findFirst().orElse(null);
    }

    private boolean canCompleteQuest(Quest quest) {
        if (quest == null || this.field_22787 == null || this.field_22787.field_1724 == null) {
            return false;
        }
        return this.field_22787.field_1724.method_31548().method_18861(quest.goal().item()) >= quest.goal().requiredAmount();
    }

    public void method_25419() {
        ClientPlayNetworking.send((class_8710)new SetVillagerFrozenC2SPacket(this.villager.method_5667(), false));
        super.method_25419();
    }

    private void sendMessage() {
        String messageText = this.inputBox.method_1882();
        if (messageText == null || messageText.trim().isEmpty()) {
            return;
        }
        String langCode = class_310.method_1551().method_1526().method_4669();
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            ClientPlayNetworking.send((class_8710)new SendDialogueMessageC2SPacket(this.villager.method_5667(), messageText, langCode));
        }
        this.inputBox.method_1852("");
    }

    public boolean method_25421() {
        return false;
    }
}

