/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.network;

import com.loracore.LoraCoreMod;
import com.loracore.api.dto.OpenAiApiDto;
import com.loracore.component.ModComponents;
import com.loracore.component.PlayerAskHistoryComponent;
import com.loracore.component.PlayerDialogueComponent;
import com.loracore.component.PlayerQuestComponent;
import com.loracore.component.VillagerDataComponent;
import com.loracore.component.data.CpuData;
import com.loracore.component.data.FileSystemsData;
import com.loracore.component.data.FirmwareData;
import com.loracore.component.data.MotherboardData;
import com.loracore.component.data.RamData;
import com.loracore.computer.VirtualFileSystemManager;
import com.loracore.item.TabletItem;
import com.loracore.network.AcceptQuestC2SPacket;
import com.loracore.network.AskAiC2SPacket;
import com.loracore.network.BootTabletS2CPacket;
import com.loracore.network.CompleteQuestC2SPacket;
import com.loracore.network.GiveGiftC2SPacket;
import com.loracore.network.RequestTabletDataC2SPacket;
import com.loracore.network.RequestVillagerDataC2SPacket;
import com.loracore.network.SendDialogueMessageC2SPacket;
import com.loracore.network.SetVillagerFrozenC2SPacket;
import com.loracore.network.vfs.VfsRequestC2SPacket;
import com.loracore.network.vfs.VfsResponseS2CPacket;
import com.loracore.quest.Quest;
import com.loracore.service.AiService;
import com.loracore.service.GiftService;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3852;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class ModNetworking {
    public static void registerC2SPackets() {
        PayloadTypeRegistry.playC2S().register(RequestTabletDataC2SPacket.ID, RequestTabletDataC2SPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(BootTabletS2CPacket.ID, BootTabletS2CPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestVillagerDataC2SPacket.ID, RequestVillagerDataC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(SendDialogueMessageC2SPacket.ID, SendDialogueMessageC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(SetVillagerFrozenC2SPacket.ID, SetVillagerFrozenC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(AskAiC2SPacket.ID, AskAiC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(AcceptQuestC2SPacket.ID, AcceptQuestC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(CompleteQuestC2SPacket.ID, CompleteQuestC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(GiveGiftC2SPacket.ID, GiveGiftC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(VfsRequestC2SPacket.ID, VfsRequestC2SPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(VfsResponseS2CPacket.ID, VfsResponseS2CPacket.CODEC);
        ModNetworking.registerTabletHandlers();
        ModNetworking.registerDialogueAndQuestHandlers();
        ModNetworking.registerVfsHandlers();
    }

    private static void registerVfsHandlers() {
        ServerPlayNetworking.registerGlobalReceiver(VfsRequestC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            server.execute(() -> {
                LoraCoreMod.LOGGER.info("[VFS] Processing VFS request on server thread: Operation={}, Path={}", (Object)payload.operation(), (Object)payload.path());
                VirtualFileSystemManager.VFSResponse response = VirtualFileSystemManager.getInstance().performOperation(payload.fsUuid(), payload.operation(), payload.path(), payload.content());
                LoraCoreMod.LOGGER.info("[VFS] Operation result: [{}]. Sending response to client for callbackId: {}", (Object)response.type(), (Object)payload.callbackId());
                ServerPlayNetworking.send((class_3222)player, (class_8710)new VfsResponseS2CPacket(payload.callbackId(), response.type(), response.data()));
            });
        });
    }

    private static void registerTabletHandlers() {
        ServerPlayNetworking.registerGlobalReceiver(RequestTabletDataC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            server.execute(() -> {
                UUID fsUuid;
                class_1799 stack = player.method_6047();
                if (!(stack.method_7909() instanceof TabletItem)) {
                    return;
                }
                MotherboardData mobo = (MotherboardData)stack.method_57824(ModComponents.MOTHERBOARD_DATA);
                if (mobo == null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Device is critically damaged. Motherboard not found.").method_27692(class_124.field_1061), true);
                    return;
                }
                Optional storageStackOpt = mobo.storage().stream().findFirst();
                if (storageStackOpt.isEmpty()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"No storage device found.").method_27692(class_124.field_1061), true);
                    return;
                }
                FileSystemsData fsData = (FileSystemsData)stack.method_57824(ModComponents.FILE_SYSTEMS_DATA);
                if (fsData == null) {
                    fsData = new FileSystemsData(new HashMap<String, UUID>());
                }
                if (!fsData.uuids().containsKey("0")) {
                    LoraCoreMod.LOGGER.info("[VFS] Tablet unformatted. Generating new VFS UUID and saving it to ItemStack NBT...");
                    fsUuid = UUID.randomUUID();
                    LoraCoreMod.LOGGER.info("[VFS UUID] Generated NEW UUID for tablet: {}", (Object)fsUuid);
                    HashMap<String, UUID> newUuids = new HashMap<String, UUID>(fsData.uuids());
                    newUuids.put("0", fsUuid);
                    FileSystemsData newFsData = new FileSystemsData(newUuids);
                    stack.method_57379(ModComponents.FILE_SYSTEMS_DATA, (Object)newFsData);
                    player.method_31548().method_5447(player.method_31548().field_7545, stack.method_7972());
                    player.method_31548().method_5431();
                } else {
                    fsUuid = fsData.uuids().get("0");
                    LoraCoreMod.LOGGER.info("[VFS UUID] Using EXISTING UUID for tablet: {}", (Object)fsUuid);
                }
                Optional<CpuData> cpuDataOpt = mobo.cpu().map(s -> (CpuData)s.method_57824(ModComponents.CPU_DATA));
                Optional<FirmwareData> firmwareDataOpt = mobo.firmware().map(s -> (FirmwareData)s.method_57824(ModComponents.FIRMWARE_DATA));
                int totalRamKb = mobo.ram().stream().mapToInt(s -> ((RamData)s.method_57825(ModComponents.RAM_DATA, (Object)new RamData(0))).sizeKb()).sum();
                if (cpuDataOpt.isEmpty() || firmwareDataOpt.isEmpty()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Device is bricked. Missing CPU or Firmware.").method_27692(class_124.field_1061), true);
                    return;
                }
                String bootScriptPath = firmwareDataOpt.get().recoveryScript().toString();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new BootTabletS2CPacket(fsUuid, bootScriptPath, cpuDataOpt.get().architecture(), totalRamKb));
            });
        });
    }

    private static void registerDialogueAndQuestHandlers() {
        ServerPlayNetworking.registerGlobalReceiver(RequestVillagerDataC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            server.execute(() -> {
                class_3218 world = player.method_51469();
                UUID villagerUuid = payload.villagerUuid();
                String langCode = payload.languageCode();
                class_1297 entity = world.method_14190(villagerUuid);
                if (!(entity instanceof class_1646)) {
                    return;
                }
                class_1646 villager = (class_1646)entity;
                VillagerDataComponent villagerComponent = (VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)villager);
                PlayerDialogueComponent playerDialogue = (PlayerDialogueComponent)ModComponents.PLAYER_DIALOGUE.get((Object)player);
                if (villagerComponent.hasGeneratedData()) {
                    playerDialogue.initializeDialogue(villager.method_5667(), "");
                    ModComponents.PLAYER_DIALOGUE.sync((Object)player);
                    return;
                }
                villagerComponent.setHasGeneratedData(true);
                villagerComponent.setVillagerName("\u0414\u0443\u043c\u0430\u0435\u0442...");
                ModComponents.VILLAGER_DATA.sync((Object)villager);
                AiService.generateVillagerPersonality(villager, langCode).whenCompleteAsync((info, error) -> {
                    if (error != null) {
                        LoraCoreMod.LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043b\u0438\u0447\u043d\u043e\u0441\u0442\u044c \u0436\u0438\u0442\u0435\u043b\u044f:", error);
                        villagerComponent.setVillagerName("\u0417\u0430\u0433\u0430\u0434\u043e\u0447\u043d\u044b\u0439 \u0436\u0438\u0442\u0435\u043b\u044c");
                        villagerComponent.setPersonality("\u042d\u0442\u043e\u0442 \u0436\u0438\u0442\u0435\u043b\u044c \u043d\u0435\u0440\u0430\u0437\u0433\u043e\u0432\u043e\u0440\u0447\u0438\u0432 \u0438 \u043f\u0440\u0435\u0434\u043f\u043e\u0447\u0438\u0442\u0430\u0435\u0442 \u043c\u043e\u043b\u0447\u0430\u0442\u044c.");
                        player.method_7353((class_2561)class_2561.method_43471((String)"error.loracore.dialogue.generic").method_27692(class_124.field_1061), true);
                    } else {
                        villagerComponent.setVillagerName(info.name());
                        villagerComponent.setPersonality(info.personality());
                    }
                    playerDialogue.initializeDialogue(villager.method_5667(), "");
                    ModComponents.VILLAGER_DATA.sync((Object)villager);
                    ModComponents.PLAYER_DIALOGUE.sync((Object)player);
                }, (Executor)server);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(SetVillagerFrozenC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            server.execute(() -> {
                class_1297 entity = player.method_51469().method_14190(payload.villagerUuid());
                if (entity instanceof class_1646) {
                    class_1646 villager = (class_1646)entity;
                    villager.method_8259((class_1657)(payload.frozen() ? player : null));
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(SendDialogueMessageC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            server.execute(() -> {
                class_1297 entity = player.method_51469().method_14190(payload.villagerUuid());
                if (!(entity instanceof class_1646)) {
                    return;
                }
                class_1646 villager = (class_1646)entity;
                PlayerDialogueComponent playerDialogue = (PlayerDialogueComponent)ModComponents.PLAYER_DIALOGUE.get((Object)player);
                playerDialogue.addMessageToHistory(payload.villagerUuid(), new OpenAiApiDto.Message("user", payload.message()));
                List<OpenAiApiDto.Message> history = playerDialogue.getDialogueHistory(payload.villagerUuid());
                AiService.continueConversation(history, payload.languageCode(), villager, player).whenCompleteAsync((response, error) -> {
                    VillagerDataComponent villagerComponent;
                    if (error != null) {
                        LoraCoreMod.LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u0432 \u0434\u0438\u0430\u043b\u043e\u0433\u0435:", error);
                        playerDialogue.addMessageToHistory(payload.villagerUuid(), new OpenAiApiDto.Message("assistant", "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043a\u0430\u043a\u0430\u044f-\u0442\u043e \u043e\u0448\u0438\u0431\u043a\u0430..."));
                        ModComponents.PLAYER_DIALOGUE.sync((Object)player);
                        return;
                    }
                    playerDialogue.addMessageToHistory(payload.villagerUuid(), new OpenAiApiDto.Message("assistant", response.dialogue()));
                    if (response.quest() != null && !(villagerComponent = (VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)villager)).hasQuestForPlayer(player.method_5667())) {
                        OpenAiApiDto.GeneratedQuestInfo questInfo = response.quest();
                        class_1792 goalItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(questInfo.goalItem()));
                        class_1792 rewardItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(questInfo.rewardItem()));
                        Quest newQuest = new Quest(UUID.randomUUID(), villager.method_5667(), questInfo.title(), questInfo.description(), new Quest.FetchGoal(goalItem, questInfo.goalAmount()), new Quest.QuestReward(rewardItem, questInfo.rewardAmount()));
                        villagerComponent.assignQuestToPlayer(player.method_5667(), newQuest);
                        ModComponents.VILLAGER_DATA.sync((Object)villager);
                    }
                    ModComponents.PLAYER_DIALOGUE.sync((Object)player);
                }, (Executor)server);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(AcceptQuestC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            UUID villagerUuid = payload.villagerUuid();
            server.execute(() -> {
                class_1297 entity = player.method_51469().method_14190(villagerUuid);
                if (!(entity instanceof class_1646)) {
                    return;
                }
                class_1646 villager = (class_1646)entity;
                VillagerDataComponent villagerData = (VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)villager);
                Quest questToAccept = villagerData.getAssignedQuest(player.method_5667());
                if (questToAccept == null) {
                    LoraCoreMod.LOGGER.warn("AcceptQuestC2SPacket: No pending quest offer found for player {} by villager {}.", (Object)player.method_5477().getString(), (Object)villagerUuid);
                    return;
                }
                PlayerQuestComponent playerQuests = (PlayerQuestComponent)ModComponents.PLAYER_QUEST.get((Object)player);
                playerQuests.addQuest(questToAccept);
                villagerData.completeQuestForPlayer(player.method_5667());
                PlayerDialogueComponent playerDialogue = (PlayerDialogueComponent)ModComponents.PLAYER_DIALOGUE.get((Object)player);
                String confirmationMsg = String.format("\u041e\u0442\u043b\u0438\u0447\u043d\u043e! \u041a\u0430\u043a \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u0438\u043d\u0435\u0441\u0435\u0448\u044c \u043c\u043d\u0435 %s (%d \u0448\u0442.), \u0434\u0430\u0439 \u043c\u043d\u0435 \u0437\u043d\u0430\u0442\u044c.", questToAccept.goal().item().method_7848().getString(), questToAccept.goal().requiredAmount());
                playerDialogue.addMessageToHistory(villagerUuid, new OpenAiApiDto.Message("assistant", confirmationMsg));
                ModComponents.PLAYER_QUEST.sync((Object)player);
                ModComponents.VILLAGER_DATA.sync((Object)villager);
                ModComponents.PLAYER_DIALOGUE.sync((Object)player);
                LoraCoreMod.LOGGER.info("AcceptQuestC2SPacket: Quest '{}' accepted by player {}.", (Object)questToAccept.title(), (Object)player.method_5477().getString());
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(CompleteQuestC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            UUID villagerUuid = payload.villagerUuid();
            server.execute(() -> {
                class_1297 entity = player.method_51469().method_14190(villagerUuid);
                if (!(entity instanceof class_1646)) {
                    LoraCoreMod.LOGGER.warn("CompleteQuestC2SPacket: Villager entity not found for UUID: {}", (Object)villagerUuid);
                    return;
                }
                class_1646 villager = (class_1646)entity;
                PlayerQuestComponent playerQuests = (PlayerQuestComponent)ModComponents.PLAYER_QUEST.get((Object)player);
                Quest activeQuest = playerQuests.getQuests().stream().filter(q -> q.villagerGiverUuid().equals(villagerUuid)).findFirst().orElse(null);
                if (activeQuest == null) {
                    return;
                }
                Quest.FetchGoal goal = activeQuest.goal();
                if (player.method_31548().method_18861(goal.item()) >= goal.requiredAmount()) {
                    player.method_31548().method_29280(itemStack -> itemStack.method_31574(goal.item()), goal.requiredAmount(), (class_1263)player.method_31548());
                    player.method_7270(new class_1799((class_1935)activeQuest.reward().item(), activeQuest.reward().amount()));
                    VillagerDataComponent villagerData = (VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)villager);
                    villagerData.addFriendship(player.method_5667(), 10);
                    playerQuests.getQuests().removeIf(q -> q.questId().equals(activeQuest.questId()));
                    PlayerDialogueComponent playerDialogue = (PlayerDialogueComponent)ModComponents.PLAYER_DIALOGUE.get((Object)player);
                    playerDialogue.addMessageToHistory(villagerUuid, new OpenAiApiDto.Message("assistant", "\u0421\u043f\u0430\u0441\u0438\u0431\u043e \u0431\u043e\u043b\u044c\u0448\u043e\u0435! \u0412\u043e\u0442 \u0442\u0432\u043e\u044f \u043d\u0430\u0433\u0440\u0430\u0434\u0430."));
                    ModComponents.PLAYER_QUEST.sync((Object)player);
                    ModComponents.VILLAGER_DATA.sync((Object)villager);
                    ModComponents.PLAYER_DIALOGUE.sync((Object)player);
                    LoraCoreMod.LOGGER.info("CompleteQuestC2SPacket: Quest '{}' completed by player {}.", (Object)activeQuest.title(), (Object)player.method_5477().getString());
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(AskAiC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            server.execute(() -> {
                PlayerAskHistoryComponent historyComponent = (PlayerAskHistoryComponent)ModComponents.PLAYER_ASK_HISTORY.get((Object)player);
                historyComponent.addMessage(new OpenAiApiDto.Message("user", payload.question()));
                ModComponents.PLAYER_ASK_HISTORY.sync((Object)player);
                AiService.getAnswer(player, historyComponent.getHistory(), payload.languageCode()).whenCompleteAsync((answer, error) -> {
                    if (error != null) {
                        LoraCoreMod.LOGGER.error("AI service failed to provide an answer", error);
                        historyComponent.addMessage(new OpenAiApiDto.Message("assistant", "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0438 \u043a AI."));
                    } else if (answer == null || answer.isBlank()) {
                        historyComponent.addMessage(new OpenAiApiDto.Message("assistant", "\u0418\u0418 \u0432\u0435\u0440\u043d\u0443\u043b \u043f\u0443\u0441\u0442\u043e\u0439 \u0438\u043b\u0438 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442."));
                    } else {
                        historyComponent.addMessage(new OpenAiApiDto.Message("assistant", (String)answer));
                    }
                    ModComponents.PLAYER_ASK_HISTORY.sync((Object)player);
                }, (Executor)server);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(GiveGiftC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            server.execute(() -> {
                class_1297 entity = player.method_51469().method_14190(payload.villagerUuid());
                if (!(entity instanceof class_1646)) {
                    return;
                }
                class_1646 villager = (class_1646)entity;
                class_1799 giftStack = player.method_6047();
                if (giftStack.method_7960()) {
                    return;
                }
                class_3852 profession = villager.method_7231().method_16924();
                GiftService.GiftResult result = GiftService.evaluateGift(profession, giftStack.method_7909());
                VillagerDataComponent villagerData = (VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)villager);
                villagerData.addFriendship(player.method_5667(), result.friendshipChange());
                String feedbackKey = switch (result.tier()) {
                    default -> throw new MatchException(null, null);
                    case GiftService.GiftTier.LOVED -> "gui.loracore.dialogue.gift.loved";
                    case GiftService.GiftTier.LIKED -> "gui.loracore.dialogue.gift.liked";
                    case GiftService.GiftTier.NEUTRAL -> "gui.loracore.dialogue.gift.neutral";
                    case GiftService.GiftTier.DISLIKED -> "gui.loracore.dialogue.gift.disliked";
                };
                PlayerDialogueComponent playerDialogue = (PlayerDialogueComponent)ModComponents.PLAYER_DIALOGUE.get((Object)player);
                playerDialogue.addMessageToHistory(villager.method_5667(), new OpenAiApiDto.Message("system", feedbackKey));
                giftStack.method_7934(1);
                ModComponents.VILLAGER_DATA.sync((Object)villager);
                ModComponents.PLAYER_DIALOGUE.sync((Object)player);
            });
        });
    }
}

