/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.service;

import com.loracore.service.AiService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_3852;
import net.minecraft.class_7923;

public class GiftService {
    private static final Map<class_3852, Set<class_1792>> LOVED_GIFTS = Map.of(class_3852.field_17056, Set.of(class_1802.field_8071, class_1802.field_8741), class_3852.field_17060, Set.of(class_1802.field_8674, class_1802.field_8598), class_3852.field_17052, Set.of(class_1802.field_8477, class_1802.field_22020), class_3852.field_17057, Set.of(class_1802.field_8478), class_3852.field_17053, Set.of(class_1802.field_8261, class_1802.field_8176), class_3852.field_17055, Set.of(class_1802.field_8463, class_1802.field_8759));
    private static final Set<class_1792> DISLIKED_GIFTS = Set.of(class_1802.field_8635, class_1802.field_8511, class_1802.field_8680, class_1802.field_8323);

    public static GiftResult evaluateGift(class_3852 profession, class_1792 item) {
        if (DISLIKED_GIFTS.contains(item)) {
            return new GiftResult(GiftTier.DISLIKED, -15);
        }
        if (LOVED_GIFTS.getOrDefault(profession, Set.of()).contains(item)) {
            return new GiftResult(GiftTier.LOVED, 20);
        }
        String itemId = class_7923.field_41178.method_10221((Object)item).toString();
        if (AiService.PROFESSION_GOAL_ITEMS.getOrDefault(profession, List.of()).contains(itemId)) {
            return new GiftResult(GiftTier.LIKED, 8);
        }
        return new GiftResult(GiftTier.NEUTRAL, 2);
    }

    public record GiftResult(GiftTier tier, int friendshipChange) {
    }

    public static enum GiftTier {
        LOVED,
        LIKED,
        NEUTRAL,
        DISLIKED;

    }
}

