/*
 * Decompiled with CFR 0.152.
 */
package com.loracore;

import com.loracore.ConfigManager;
import com.loracore.StructureNameManager;
import com.loracore.item.ModItems;
import com.loracore.network.ModNetworking;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoraCoreMod
implements ModInitializer {
    public static final String MOD_ID = "loracore";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"loracore");
    private static final Map<UUID, String> lastKnownStructurePosKeyForPlayer = new HashMap<UUID, String>();
    private static final Map<UUID, Long> lastStructureCheckTickForPlayer = new HashMap<UUID, Long>();
    private static final int STRUCTURE_CHECK_INTERVAL_TICKS = 60;
    private static StructureNameManager structureNameManager;

    public void onInitialize() {
        LOGGER.info("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043c\u043e\u0434\u0430 AI Mod...");
        ConfigManager.loadConfig();
        ModNetworking.registerC2SPackets();
        ModItems.registerModItems();
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world.method_27983() == class_1937.field_25179) {
                structureNameManager = StructureNameManager.get(world);
                LOGGER.info("StructureNameManager \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0434\u043b\u044f \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0433\u043e \u043c\u0438\u0440\u0430.");
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            long currentTick = server.method_3780();
            if (structureNameManager == null) {
                return;
            }
            for (class_3222 player : server.method_3760().method_14571()) {
                UUID uuid = player.method_5667();
                long lastCheck = lastStructureCheckTickForPlayer.getOrDefault(uuid, 0L);
                if (currentTick - lastCheck < 60L) continue;
                lastStructureCheckTickForPlayer.put(uuid, currentTick);
                class_3218 world = player.method_51469();
                if (world.method_27983() == class_1937.field_25179) {
                    StructureNameManager.StructureCheckResult result = structureNameManager.getOrCreateStructureDataAt(world, player.method_24515());
                    String newStructurePosKey = result.getPosKey().orElse(null);
                    String oldStructurePosKey = lastKnownStructurePosKeyForPlayer.get(uuid);
                    if (Objects.equals(oldStructurePosKey, newStructurePosKey)) continue;
                    lastKnownStructurePosKeyForPlayer.put(uuid, newStructurePosKey);
                    player.field_13987.method_14364((class_2596)new class_5905(5, 10, 5));
                    player.field_13987.method_14364((class_2596)new class_5903((class_2561)class_2561.method_43473()));
                    player.field_13987.method_14364((class_2596)new class_5904((class_2561)class_2561.method_43473()));
                    if (newStructurePosKey != null) {
                        result.getData().ifPresent(data -> {
                            class_5250 structureName = class_2561.method_43470((String)data.name);
                            class_5250 structureDescription = class_2561.method_43470((String)data.description);
                            if (data.isGenerating.get()) {
                                player.method_7353((class_2561)class_2561.method_43469((String)"structure.loracore.discover.generating", (Object[])new Object[]{structureName}).method_27692(class_124.field_1054), false);
                                player.field_13987.method_14364((class_2596)new class_5905(10, 70, 20));
                                player.field_13987.method_14364((class_2596)new class_5904((class_2561)structureName));
                            } else {
                                player.method_7353((class_2561)class_2561.method_43469((String)"structure.loracore.enter.title", (Object[])new Object[]{structureName.method_27661().method_27692(class_124.field_1067)}).method_27692(class_124.field_1060), false);
                                player.method_7353((class_2561)class_2561.method_43469((String)"structure.loracore.enter.description", (Object[])new Object[]{structureDescription}).method_27692(class_124.field_1060), false);
                                player.field_13987.method_14364((class_2596)new class_5905(10, 70, 20));
                                player.field_13987.method_14364((class_2596)new class_5904((class_2561)structureName));
                                player.field_13987.method_14364((class_2596)new class_5903((class_2561)structureDescription));
                            }
                        });
                        continue;
                    }
                    player.method_7353((class_2561)class_2561.method_43471((String)"structure.loracore.leave.area").method_27692(class_124.field_1080), false);
                    continue;
                }
                if (!lastKnownStructurePosKeyForPlayer.containsKey(uuid)) continue;
                lastKnownStructurePosKeyForPlayer.remove(uuid);
                player.method_7353((class_2561)class_2561.method_43471((String)"structure.loracore.leave.dimension").method_27692(class_124.field_1080), false);
                player.field_13987.method_14364((class_2596)new class_5905(0, 0, 0));
                player.field_13987.method_14364((class_2596)new class_5903((class_2561)class_2561.method_43473()));
                player.field_13987.method_14364((class_2596)new class_5904((class_2561)class_2561.method_43473()));
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            lastKnownStructurePosKeyForPlayer.remove(handler.field_14140.method_5667());
            lastStructureCheckTickForPlayer.remove(handler.field_14140.method_5667());
        });
    }
}

