/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.api;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.loracore.api.dto.OpenAiApiDto;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OpenAiApiClient {
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient();
    private static final Gson GSON = new Gson();
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");

    public CompletableFuture<OpenAiApiDto.ModelsListResponse> fetchModelsAsync(String apiUrl, String apiKey) {
        CompletableFuture<OpenAiApiDto.ModelsListResponse> future = new CompletableFuture<OpenAiApiDto.ModelsListResponse>();
        Request request = new Request.Builder().url(apiUrl + "/models").header("Authorization", "Bearer " + apiKey).get().build();
        this.executeRequest(request, OpenAiApiDto.ModelsListResponse.class, future);
        return future;
    }

    public CompletableFuture<OpenAiApiDto.OpenAiResponse> createChatCompletionAsync(String apiUrl, String apiKey, OpenAiApiDto.ChatRequest payload) {
        CompletableFuture<OpenAiApiDto.OpenAiResponse> future = new CompletableFuture<OpenAiApiDto.OpenAiResponse>();
        try {
            String jsonBody = GSON.toJson((Object)payload);
            RequestBody body = RequestBody.create((String)jsonBody, (MediaType)JSON);
            Request request = new Request.Builder().url(apiUrl + "/chat/completions").header("Authorization", "Bearer " + apiKey).post(body).build();
            this.executeRequest(request, OpenAiApiDto.OpenAiResponse.class, future);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private <T> void executeRequest(Request request, final Class<T> responseClass, final CompletableFuture<T> future) {
        HTTP_CLIENT.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }

            public void onResponse(Call call, Response response) {
                try (ResponseBody responseBody = response.body();){
                    if (!response.isSuccessful() || responseBody == null) {
                        String errorBody = responseBody != null ? responseBody.string() : "No response body";
                        future.completeExceptionally(new IOException("API request failed with code " + response.code() + ": " + errorBody));
                        return;
                    }
                    String bodyString = responseBody.string();
                    Object result = GSON.fromJson(bodyString, responseClass);
                    if (result == null) {
                        future.completeExceptionally(new IOException("Failed to parse JSON response: " + bodyString));
                    } else {
                        future.complete(result);
                    }
                }
                catch (JsonSyntaxException | IOException e) {
                    future.completeExceptionally(e);
                }
            }
        });
    }
}

