/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.network;

import com.loracore.LoraCoreMod;
import com.loracore.api.dto.OpenAiApiDto;
import com.loracore.component.ModComponents;
import com.loracore.component.PlayerDialogueComponent;
import com.loracore.component.PlayerQuestComponent;
import com.loracore.component.VillagerDataComponent;
import com.loracore.network.AcceptQuestC2SPacket;
import com.loracore.network.AskAiC2SPacket;
import com.loracore.network.CompleteQuestC2SPacket;
import com.loracore.network.RequestVillagerDataC2SPacket;
import com.loracore.network.SendDialogueMessageC2SPacket;
import com.loracore.network.SetVillagerFrozenC2SPacket;
import com.loracore.quest.Quest;
import com.loracore.service.AiService;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ModNetworking {
    public static void registerC2SPackets() {
        PayloadTypeRegistry.playC2S().register(RequestVillagerDataC2SPacket.ID, RequestVillagerDataC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(SendDialogueMessageC2SPacket.ID, SendDialogueMessageC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(SetVillagerFrozenC2SPacket.ID, SetVillagerFrozenC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(AskAiC2SPacket.ID, AskAiC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(AcceptQuestC2SPacket.ID, AcceptQuestC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(CompleteQuestC2SPacket.ID, CompleteQuestC2SPacket.CODEC);
        ModNetworking.registerPacketHandlers();
    }

    private static void registerPacketHandlers() {
        ServerPlayNetworking.registerGlobalReceiver(RequestVillagerDataC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            server.execute(() -> {
                class_3218 world = player.method_51469();
                UUID villagerUuid = payload.villagerUuid();
                String langCode = payload.languageCode();
                class_1297 entity = world.method_14190(villagerUuid);
                if (!(entity instanceof class_1646)) {
                    return;
                }
                class_1646 villager = (class_1646)entity;
                VillagerDataComponent villagerComponent = (VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)villager);
                PlayerDialogueComponent playerDialogue = (PlayerDialogueComponent)ModComponents.PLAYER_DIALOGUE.get((Object)player);
                if (villagerComponent.hasGeneratedData()) {
                    String systemPrompt = "\u0422\u044b - " + villagerComponent.getVillagerName() + ". " + villagerComponent.getPersonality();
                    if (!villagerComponent.hasQuestForPlayer(player.method_5667())) {
                        systemPrompt = systemPrompt + " \u0422\u044b \u043c\u043e\u0436\u0435\u0448\u044c \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0438\u0442\u044c \u0438\u0433\u0440\u043e\u043a\u0443 \u043f\u0440\u043e\u0441\u0442\u043e\u0439 \u043a\u0432\u0435\u0441\u0442, \u0435\u0441\u043b\u0438 \u043e\u043d \u043f\u043e\u043f\u0440\u043e\u0441\u0438\u0442 \u0438\u043b\u0438 \u0435\u0441\u043b\u0438 \u044d\u0442\u043e \u0443\u043c\u0435\u0441\u0442\u043d\u043e. \u0415\u0441\u043b\u0438 \u0440\u0435\u0448\u0438\u0448\u044c \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0438\u0442\u044c, \u0437\u0430\u043a\u043e\u043d\u0447\u0438 \u0441\u0432\u043e\u0439 \u043e\u0442\u0432\u0435\u0442 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u043c \u0442\u0435\u0433\u043e\u043c [QUEST_OFFER]. \u041d\u0435 \u043f\u0440\u0438\u0434\u0443\u043c\u044b\u0432\u0430\u0439 \u0434\u0435\u0442\u0430\u043b\u0438 \u043a\u0432\u0435\u0441\u0442\u0430 (\u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b, \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e) \u0441\u0430\u043c, \u0430 \u043f\u0440\u043e\u0441\u0442\u043e \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0438 \u043a\u0432\u0435\u0441\u0442.";
                    }
                    systemPrompt = systemPrompt + " \u0413\u043e\u0432\u043e\u0440\u0438 \u0441 \u0438\u0433\u0440\u043e\u043a\u043e\u043c \u043e\u0442 \u044d\u0442\u043e\u0433\u043e \u043b\u0438\u0446\u0430.";
                    playerDialogue.initializeDialogue(villager.method_5667(), systemPrompt);
                    ModComponents.PLAYER_DIALOGUE.sync((Object)player);
                    return;
                }
                villagerComponent.setHasGeneratedData(true);
                villagerComponent.setVillagerName("\u0414\u0443\u043c\u0430\u0435\u0442...");
                ModComponents.VILLAGER_DATA.sync((Object)villager);
                AiService.generateVillagerPersonality(villager, langCode).whenCompleteAsync((info, error) -> {
                    if (error != null) {
                        LoraCoreMod.LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043b\u0438\u0447\u043d\u043e\u0441\u0442\u044c \u0436\u0438\u0442\u0435\u043b\u044f:", error);
                        villagerComponent.setHasGeneratedData(false);
                        villagerComponent.setVillagerName("");
                    } else {
                        villagerComponent.setVillagerName(info.name());
                        villagerComponent.setPersonality(info.personality());
                        String finalSystemPrompt = "\u0422\u044b - " + info.name() + ". " + info.personality();
                        if (!villagerComponent.hasQuestForPlayer(player.method_5667())) {
                            finalSystemPrompt = finalSystemPrompt + " \u0422\u044b \u043c\u043e\u0436\u0435\u0448\u044c \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0438\u0442\u044c \u0438\u0433\u0440\u043e\u043a\u0443 \u043f\u0440\u043e\u0441\u0442\u043e\u0439 \u043a\u0432\u0435\u0441\u0442, \u0435\u0441\u043b\u0438 \u043e\u043d \u043f\u043e\u043f\u0440\u043e\u0441\u0438\u0442 \u0438\u043b\u0438 \u0435\u0441\u043b\u0438 \u044d\u0442\u043e \u0443\u043c\u0435\u0441\u0442\u043d\u043e. \u0415\u0441\u043b\u0438 \u0440\u0435\u0448\u0438\u0448\u044c \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0438\u0442\u044c, \u0437\u0430\u043a\u043e\u043d\u0447\u0438 \u0441\u0432\u043e\u0439 \u043e\u0442\u0432\u0435\u0442 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u043c \u0442\u0435\u0433\u043e\u043c [QUEST_OFFER]. \u041d\u0435 \u043f\u0440\u0438\u0434\u0443\u043c\u044b\u0432\u0430\u0439 \u0434\u0435\u0442\u0430\u043b\u0438 \u043a\u0432\u0435\u0441\u0442\u0430 (\u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b, \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e) \u0441\u0430\u043c, \u0430 \u043f\u0440\u043e\u0441\u0442\u043e \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0438 \u043a\u0432\u0435\u0441\u0442.";
                        }
                        finalSystemPrompt = finalSystemPrompt + " \u0413\u043e\u0432\u043e\u0440\u0438 \u0441 \u0438\u0433\u0440\u043e\u043a\u043e\u043c \u043e\u0442 \u044d\u0442\u043e\u0433\u043e \u043b\u0438\u0446\u0430.";
                        playerDialogue.initializeDialogue(villager.method_5667(), finalSystemPrompt);
                        ModComponents.PLAYER_DIALOGUE.sync((Object)player);
                    }
                    ModComponents.VILLAGER_DATA.sync((Object)villager);
                }, (Executor)server);
            });
        });
        ModNetworking.registerOtherPacketHandlers();
    }

    private static void registerOtherPacketHandlers() {
        ServerPlayNetworking.registerGlobalReceiver(SendDialogueMessageC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            server.execute(() -> {
                class_1297 entity = player.method_51469().method_14190(payload.villagerUuid());
                if (!(entity instanceof class_1646)) {
                    return;
                }
                class_1646 villager = (class_1646)entity;
                VillagerDataComponent villagerComponent = (VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)villager);
                PlayerDialogueComponent playerDialogue = (PlayerDialogueComponent)ModComponents.PLAYER_DIALOGUE.get((Object)player);
                playerDialogue.addMessageToHistory(payload.villagerUuid(), new OpenAiApiDto.Message("user", payload.message()));
                ArrayList<OpenAiApiDto.Message> history = new ArrayList<OpenAiApiDto.Message>(playerDialogue.getDialogueHistory(payload.villagerUuid()));
                String questInstruction = " \u0422\u044b \u043c\u043e\u0436\u0435\u0448\u044c \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0438\u0442\u044c \u0438\u0433\u0440\u043e\u043a\u0443 \u043f\u0440\u043e\u0441\u0442\u043e\u0439 \u043a\u0432\u0435\u0441\u0442, \u0435\u0441\u043b\u0438 \u043e\u043d \u043f\u043e\u043f\u0440\u043e\u0441\u0438\u0442 \u0438\u043b\u0438 \u0435\u0441\u043b\u0438 \u044d\u0442\u043e \u0443\u043c\u0435\u0441\u0442\u043d\u043e. \u0415\u0441\u043b\u0438 \u0440\u0435\u0448\u0438\u0448\u044c \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0438\u0442\u044c, \u0437\u0430\u043a\u043e\u043d\u0447\u0438 \u0441\u0432\u043e\u0439 \u043e\u0442\u0432\u0435\u0442 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u043c \u0442\u0435\u0433\u043e\u043c [QUEST_OFFER]. \u041d\u0435 \u043f\u0440\u0438\u0434\u0443\u043c\u044b\u0432\u0430\u0439 \u0434\u0435\u0442\u0430\u043b\u0438 \u043a\u0432\u0435\u0441\u0442\u0430 (\u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b, \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e) \u0441\u0430\u043c, \u0430 \u043f\u0440\u043e\u0441\u0442\u043e \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0438 \u043a\u0432\u0435\u0441\u0442.";
                if (!history.isEmpty() && "system".equals(((OpenAiApiDto.Message)history.get(0)).role())) {
                    OpenAiApiDto.Message oldPrompt = (OpenAiApiDto.Message)history.get(0);
                    Object newContent = oldPrompt.content();
                    if (!villagerComponent.hasQuestForPlayer(player.method_5667()) && !((String)newContent).contains(questInstruction)) {
                        newContent = (String)newContent + questInstruction;
                    } else if (villagerComponent.hasQuestForPlayer(player.method_5667()) && ((String)newContent).contains(questInstruction)) {
                        newContent = ((String)newContent).replace(questInstruction, "");
                    }
                    history.set(0, new OpenAiApiDto.Message(oldPrompt.role(), (String)newContent));
                }
                AiService.continueConversation(history, payload.languageCode()).whenCompleteAsync((response, error) -> {
                    String aiResponseContent;
                    if (error != null) {
                        LoraCoreMod.LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u0432\u0435\u0442 \u0432 \u0434\u0438\u0430\u043b\u043e\u0433\u0435:", error);
                        aiResponseContent = "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043a\u0430\u043a\u0430\u044f-\u0442\u043e \u043e\u0448\u0438\u0431\u043a\u0430...";
                    } else {
                        aiResponseContent = response;
                    }
                    if (aiResponseContent.contains("[QUEST_OFFER]") && !villagerComponent.hasQuestForPlayer(player.method_5667())) {
                        String baseAiResponse = aiResponseContent.replace("[QUEST_OFFER]", "").trim();
                        AiService.generateQuest(villager, player, payload.languageCode()).whenCompleteAsync((generatedQuest, questError) -> {
                            if (questError != null) {
                                LoraCoreMod.LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u0432\u0435\u0441\u0442 \u043f\u043e\u0441\u043b\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f AI:", questError);
                                playerDialogue.addMessageToHistory(payload.villagerUuid(), new OpenAiApiDto.Message("assistant", baseAiResponse + " (\u041a\u0432\u0435\u0441\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0438\u0437-\u0437\u0430 \u043e\u0448\u0438\u0431\u043a\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438.)"));
                            } else {
                                villagerComponent.assignQuestToPlayer(player.method_5667(), (Quest)generatedQuest);
                                String questDetailsFormatted = String.format(" \u0423 \u043c\u0435\u043d\u044f \u0435\u0441\u0442\u044c \u0434\u043b\u044f \u0442\u0435\u0431\u044f \u043d\u0435\u0431\u043e\u043b\u044c\u0448\u0430\u044f \u0437\u0430\u0434\u0430\u0447\u043a\u0430! \u041d\u0443\u0436\u043d\u043e \u043f\u043e\u043c\u043e\u0447\u044c \u043c\u043d\u0435 \u0434\u043e\u0431\u044b\u0442\u044c %s (%d \u0448\u0442.). \u041a\u0430\u043a \u0442\u0435\u0431\u0435 \u0442\u0430\u043a\u043e\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435? \u0413\u043e\u0442\u043e\u0432 \u0432\u0437\u044f\u0442\u044c\u0441\u044f?", generatedQuest.goal().item().method_7848().getString(), generatedQuest.goal().requiredAmount());
                                playerDialogue.addMessageToHistory(payload.villagerUuid(), new OpenAiApiDto.Message("assistant", baseAiResponse + questDetailsFormatted + " [QUEST_OFFER]"));
                            }
                            ModComponents.PLAYER_DIALOGUE.sync((Object)player);
                            ModComponents.VILLAGER_DATA.sync((Object)villager);
                        }, (Executor)server);
                    } else {
                        playerDialogue.addMessageToHistory(payload.villagerUuid(), new OpenAiApiDto.Message("assistant", aiResponseContent));
                        ModComponents.PLAYER_DIALOGUE.sync((Object)player);
                    }
                }, (Executor)server);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(AskAiC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server != null) {
                server.execute(() -> AiService.getAnswer(player, payload.question(), payload.languageCode()));
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(SetVillagerFrozenC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            server.execute(() -> {
                class_1297 entity = player.method_51469().method_14190(payload.villagerUuid());
                if (entity instanceof class_1646) {
                    class_1646 villager = (class_1646)entity;
                    villager.method_8259((class_1657)(payload.frozen() ? player : null));
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(AcceptQuestC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            String langCode = payload.languageCode();
            UUID villagerUuid = payload.villagerUuid();
            server.execute(() -> {
                class_1297 entity = player.method_51469().method_14190(villagerUuid);
                if (!(entity instanceof class_1646)) {
                    return;
                }
                class_1646 villager = (class_1646)entity;
                VillagerDataComponent villagerData = (VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)villager);
                PlayerQuestComponent playerQuests = (PlayerQuestComponent)ModComponents.PLAYER_QUEST.get((Object)player);
                PlayerDialogueComponent playerDialogue = (PlayerDialogueComponent)ModComponents.PLAYER_DIALOGUE.get((Object)player);
                Quest questToAccept = villagerData.getAssignedQuest(player.method_5667());
                if (questToAccept == null) {
                    LoraCoreMod.LOGGER.warn("AcceptQuestC2SPacket: No pending quest offer found for player {} by villager {}. Cannot accept.", (Object)player.method_5477().getString(), (Object)villagerUuid);
                    return;
                }
                playerQuests.addQuest(questToAccept);
                String confirmationMsg = String.format("\u041e\u0442\u043b\u0438\u0447\u043d\u043e! \u041a\u0430\u043a \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u0438\u043d\u0435\u0441\u0435\u0448\u044c \u043c\u043d\u0435 %s (%d \u0448\u0442.), \u0434\u0430\u0439 \u043c\u043d\u0435 \u0437\u043d\u0430\u0442\u044c.", questToAccept.goal().item().method_7848().getString(), questToAccept.goal().requiredAmount());
                playerDialogue.addMessageToHistory(villagerUuid, new OpenAiApiDto.Message("assistant", confirmationMsg));
                ModComponents.PLAYER_QUEST.sync((Object)player);
                ModComponents.VILLAGER_DATA.sync((Object)villager);
                ModComponents.PLAYER_DIALOGUE.sync((Object)player);
                LoraCoreMod.LOGGER.info("AcceptQuestC2SPacket: Quest '{}' (ID: {}) accepted by player {}.", new Object[]{questToAccept.title(), questToAccept.questId(), player.method_5477().getString()});
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(CompleteQuestC2SPacket.ID, (payload, context) -> {
            class_3222 player = context.player();
            MinecraftServer server = player.method_5682();
            if (server == null) {
                return;
            }
            UUID villagerUuid = payload.villagerUuid();
            server.execute(() -> {
                class_1297 entity = player.method_51469().method_14190(villagerUuid);
                if (!(entity instanceof class_1646)) {
                    LoraCoreMod.LOGGER.warn("CompleteQuestC2SPacket: Villager entity not found or not a villager for UUID: {}", (Object)villagerUuid);
                    return;
                }
                class_1646 villager = (class_1646)entity;
                VillagerDataComponent villagerData = (VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)villager);
                Quest quest = villagerData.getAssignedQuest(player.method_5667());
                if (quest == null) {
                    LoraCoreMod.LOGGER.info("CompleteQuestC2SPacket: No quest assigned to player {} by villager {}.", (Object)player.method_5477().getString(), (Object)villagerData.getVillagerName());
                    return;
                }
                Quest.FetchGoal goal = quest.goal();
                boolean hasEnoughItems = player.method_31548().method_18861(goal.item()) >= goal.requiredAmount();
                LoraCoreMod.LOGGER.info("CompleteQuestC2SPacket: Checking quest for player {}. Quest: '{}', Goal Item: {}, Required: {}, Has: {}. Can complete: {}. Villager: {}", new Object[]{player.method_5477().getString(), quest.title(), goal.item().method_7848().getString(), goal.requiredAmount(), player.method_31548().method_18861(goal.item()), hasEnoughItems, villagerData.getVillagerName()});
                if (hasEnoughItems) {
                    player.method_31548().method_29280(itemStack -> itemStack.method_31574(goal.item()), goal.requiredAmount(), (class_1263)player.method_31548());
                    player.method_7270(new class_1799((class_1935)quest.reward().item(), quest.reward().amount()));
                    villagerData.completeQuestForPlayer(player.method_5667());
                    PlayerQuestComponent playerQuests = (PlayerQuestComponent)ModComponents.PLAYER_QUEST.get((Object)player);
                    playerQuests.getQuests().removeIf(q -> q.questId().equals(quest.questId()));
                    PlayerDialogueComponent playerDialogue = (PlayerDialogueComponent)ModComponents.PLAYER_DIALOGUE.get((Object)player);
                    playerDialogue.addMessageToHistory(villagerUuid, new OpenAiApiDto.Message("assistant", "\u0421\u043f\u0430\u0441\u0438\u0431\u043e \u0431\u043e\u043b\u044c\u0448\u043e\u0435! \u0412\u043e\u0442 \u0442\u0432\u043e\u044f \u043d\u0430\u0433\u0440\u0430\u0434\u0430."));
                    ModComponents.PLAYER_QUEST.sync((Object)player);
                    ModComponents.VILLAGER_DATA.sync((Object)villager);
                    ModComponents.PLAYER_DIALOGUE.sync((Object)player);
                    LoraCoreMod.LOGGER.info("CompleteQuestC2SPacket: Quest '{}' completed successfully for player {}.", (Object)quest.title(), (Object)player.method_5477().getString());
                } else {
                    LoraCoreMod.LOGGER.info("CompleteQuestC2SPacket: Player {} does not have enough items to complete quest '{}'.", (Object)player.method_5477().getString(), (Object)quest.title());
                }
            });
        });
    }
}

