/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.service;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.loracore.LoraCoreMod;
import com.loracore.ModConfig;
import com.loracore.api.OpenAiApiClient;
import com.loracore.api.dto.OpenAiApiDto;
import com.loracore.component.ModComponents;
import com.loracore.component.VillagerDataComponent;
import com.loracore.quest.Quest;
import com.loracore.service.RecipeService;
import com.loracore.util.PlayerContextProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class AiService {
    private static final OpenAiApiClient apiClient = new OpenAiApiClient();
    private static final Gson GSON = new Gson();
    private static List<String> availableModels = new ArrayList<String>();
    private static final List<String> CRAFTING_KEYWORDS = List.of("\u0441\u043a\u0440\u0430\u0444\u0442\u0438\u0442\u044c", "\u0441\u0434\u0435\u043b\u0430\u0442\u044c", "\u0440\u0435\u0446\u0435\u043f\u0442", "\u043a\u0440\u0430\u0444\u0442", "craft", "make", "recipe");

    private static String getLanguageInstruction(String langCode) {
        String languageName = switch (langCode) {
            case "ru_ru" -> "\u0421\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u0440\u0443\u0441\u0441\u043a\u0438\u0439";
            case "rpr" -> "\u0414\u043e\u0440\u0435\u0444\u043e\u0440\u043c\u0435\u043d\u043d\u044b\u0439 \u0440\u0443\u0441\u0441\u043a\u0438\u0439 (\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439 \u0431\u0443\u043a\u0432\u0443 \u0463, \u0431\u0443\u043a\u0432\u0443 \u0456, \u0438 \u0442\u0432\u0435\u0440\u0434\u044b\u0439 \u0437\u043d\u0430\u043a\u044a \u043d\u0430 \u043a\u043e\u043d\u0446\u0435 \u0441\u043b\u043e\u0432\u044a \u043f\u043e\u0441\u043b\u0435 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u044b\u0445\u044a)";
            default -> "English (US)";
        };
        return "\u0412\u0430\u0436\u043d\u043e: \u0422\u0432\u043e\u0439 \u043e\u0442\u0432\u0435\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0430\u043f\u0438\u0441\u0430\u043d \u0438\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u043d\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u043c \u044f\u0437\u044b\u043a\u0435: " + languageName + ".";
    }

    public static List<String> getAvailableModels() {
        return Collections.unmodifiableList(availableModels);
    }

    public static CompletableFuture<List<String>> fetchModels() {
        String apiKey = ModConfig.instance.API_KEY;
        String apiUrl = ModConfig.instance.API_URL;
        if (apiKey == null || apiKey.trim().isEmpty()) {
            return CompletableFuture.failedFuture(new IOException("API key is not configured"));
        }
        return apiClient.fetchModelsAsync(apiUrl, apiKey).thenApply(modelsResponse -> {
            if (modelsResponse == null || modelsResponse.data() == null) {
                return List.of();
            }
            List modelIds = modelsResponse.data().stream().map(OpenAiApiDto.ModelData::id).sorted().collect(Collectors.toList());
            availableModels = new ArrayList(modelIds);
            return modelIds;
        });
    }

    public static void getAnswer(class_3222 player, String question, String languageCode) {
        Optional<String> recipeInfo;
        String apiKey = ModConfig.instance.API_KEY;
        String apiUrl = ModConfig.instance.API_URL;
        String modelId = ModConfig.instance.MODEL_ID;
        if (apiKey.trim().isEmpty()) {
            player.method_43496((class_2561)class_2561.method_43471((String)"error.loracore.api_key_missing").method_27692(class_124.field_1061));
            return;
        }
        String lowerCaseQuestion = question.toLowerCase();
        boolean isCraftingQuestion = CRAFTING_KEYWORDS.stream().anyMatch(lowerCaseQuestion::contains);
        String systemPrompt = PlayerContextProvider.getContextFor(player) + "\n" + AiService.getLanguageInstruction(languageCode);
        if (isCraftingQuestion && (recipeInfo = RecipeService.findRecipeFromQuery(question, player)).isPresent()) {
            systemPrompt = systemPrompt + "\n\u0412\u0410\u0416\u041d\u041e: \u0418\u0433\u0440\u043e\u043a \u0441\u043f\u0440\u043e\u0441\u0438\u043b \u043e \u0440\u0435\u0446\u0435\u043f\u0442\u0435. \u0412\u043e\u0442 \u0442\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u0438\u0433\u0440\u044b:\n---\n" + recipeInfo.get() + "\n---\n\u0422\u0432\u043e\u0439 \u043e\u0442\u0432\u0435\u0442 \u0414\u041e\u041b\u0416\u0415\u041d \u043e\u0441\u043d\u043e\u0432\u044b\u0432\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u044d\u0442\u0438\u0445 \u0434\u0430\u043d\u043d\u044b\u0445. \u041e\u0431\u044a\u044f\u0441\u043d\u0438 \u044d\u0442\u043e\u0442 \u0440\u0435\u0446\u0435\u043f\u0442 \u0438\u0433\u0440\u043e\u043a\u0443 \u043f\u0440\u043e\u0441\u0442\u044b\u043c\u0438 \u0441\u043b\u043e\u0432\u0430\u043c\u0438.";
        }
        List<OpenAiApiDto.Message> messages = List.of(new OpenAiApiDto.Message("system", systemPrompt), new OpenAiApiDto.Message("user", question));
        OpenAiApiDto.ChatRequest chatRequest = new OpenAiApiDto.ChatRequest(modelId, messages, 250);
        apiClient.createChatCompletionAsync(apiUrl, apiKey, chatRequest).whenCompleteAsync((response, error) -> {
            if (error != null) {
                player.method_43496((class_2561)class_2561.method_43471((String)"error.loracore.api_connection_failed").method_27692(class_124.field_1061));
                return;
            }
            if (response.choices() == null || response.choices().isEmpty()) {
                player.method_43496((class_2561)class_2561.method_43471((String)"error.loracore.api_empty_response").method_27692(class_124.field_1061));
                return;
            }
            String answer = response.choices().get(0).message().content();
            player.method_43496((class_2561)class_2561.method_43469((String)"chat.loracore.ai.response_prefix", (Object[])new Object[]{class_2561.method_43470((String)answer).method_27692(class_124.field_1068)}).method_27692(class_124.field_1060));
        }, (Executor)player.method_5682());
    }

    public static CompletableFuture<OpenAiApiDto.GeneratedVillagerInfo> generateVillagerPersonality(class_1646 villager, String languageCode) {
        String apiKey = ModConfig.instance.API_KEY;
        String apiUrl = ModConfig.instance.API_URL;
        String modelId = ModConfig.instance.MODEL_ID;
        if (apiKey.trim().isEmpty()) {
            return CompletableFuture.failedFuture(new IOException("API key not set."));
        }
        String profession = class_7923.field_41195.method_10221((Object)villager.method_7231().method_16924()).toString();
        String biome = villager.method_37908().method_23753(villager.method_24515()).method_40230().map(k -> k.method_29177().toString()).orElse("unknown");
        String langInstruction = AiService.getLanguageInstruction(languageCode);
        String prompt = "%s\nYou are a scriptwriter for Minecraft. Create a short personality for a village NPC.\nProfession: %s. Biome: %s.\nInvent a simple, memorable name (1-2 words) and a brief personality description (1 sentence).\nReply ONLY in JSON format: { \"name\": \"Villager's Name\", \"personality\": \"Description of their personality.\" }\n".formatted(langInstruction, profession, biome);
        List<OpenAiApiDto.Message> messages = List.of(new OpenAiApiDto.Message("system", "You only reply in JSON format."), new OpenAiApiDto.Message("user", prompt));
        OpenAiApiDto.ChatRequest payload = new OpenAiApiDto.ChatRequest(modelId, messages, 150);
        return apiClient.createChatCompletionAsync(apiUrl, apiKey, payload).thenApply(response -> (OpenAiApiDto.GeneratedVillagerInfo)GSON.fromJson(response.choices().getFirst().message().content(), OpenAiApiDto.GeneratedVillagerInfo.class));
    }

    public static CompletableFuture<OpenAiApiDto.GeneratedStructureInfo> generateStructureInfo(String structureType, String biomeId) {
        String apiKey = ModConfig.instance.API_KEY;
        String apiUrl = ModConfig.instance.API_URL;
        String modelId = ModConfig.instance.MODEL_ID;
        if (apiKey.trim().isEmpty()) {
            return CompletableFuture.failedFuture(new IOException("API key not set."));
        }
        String prompt = AiService.createStructurePrompt(structureType, biomeId);
        List<OpenAiApiDto.Message> messages = List.of(new OpenAiApiDto.Message("system", "You only reply in JSON format."), new OpenAiApiDto.Message("user", prompt));
        OpenAiApiDto.ChatRequest payload = new OpenAiApiDto.ChatRequest(modelId, messages, 100);
        return apiClient.createChatCompletionAsync(apiUrl, apiKey, payload).thenApply(response -> {
            if (response.choices() == null || response.choices().isEmpty()) {
                throw new RuntimeException("AI returned an empty or invalid choice list.");
            }
            return AiService.parseGeneratedInfo(response.choices().get(0).message().content());
        });
    }

    public static CompletableFuture<String> continueConversation(List<OpenAiApiDto.Message> history, String languageCode) {
        String apiKey = ModConfig.instance.API_KEY;
        String apiUrl = ModConfig.instance.API_URL;
        String modelId = ModConfig.instance.MODEL_ID;
        ArrayList<OpenAiApiDto.Message> messages = new ArrayList<OpenAiApiDto.Message>(history);
        String languageInstruction = AiService.getLanguageInstruction(languageCode);
        if (!messages.isEmpty() && "system".equals(((OpenAiApiDto.Message)messages.get(0)).role())) {
            OpenAiApiDto.Message oldPrompt = (OpenAiApiDto.Message)messages.get(0);
            messages.set(0, new OpenAiApiDto.Message(oldPrompt.role(), oldPrompt.content() + "\n" + languageInstruction));
        } else {
            messages.add(0, new OpenAiApiDto.Message("system", languageInstruction));
        }
        OpenAiApiDto.ChatRequest payload = new OpenAiApiDto.ChatRequest(modelId, messages, 200);
        return apiClient.createChatCompletionAsync(apiUrl, apiKey, payload).thenApply(response -> {
            if (response.choices() == null || response.choices().isEmpty()) {
                throw new RuntimeException("AI returned an empty or invalid choice list.");
            }
            return response.choices().getFirst().message().content();
        });
    }

    private static String createStructurePrompt(String structureType, String biomeId) {
        String friendlyStructure = structureType.replace("minecraft:", "").replace("_", " ");
        String friendlyBiome = biomeId.replace("minecraft:", "").replace("_", " ");
        return "Generate a unique, short (1-3 words) name and a very brief (1 sentence) description for a structure of type '%s' in a '%s' biome.\nThe name should be in a fantasy/Minecraft style.\nReply ONLY in JSON format: { \"name\": \"The Name\", \"description\": \"A description.\" }\n".formatted(friendlyStructure, friendlyBiome);
    }

    private static OpenAiApiDto.GeneratedStructureInfo parseGeneratedInfo(String jsonContent) {
        String cleanJson = jsonContent.replace("```json", "").replace("```", "").trim();
        try {
            OpenAiApiDto.GeneratedStructureInfo info = (OpenAiApiDto.GeneratedStructureInfo)GSON.fromJson(cleanJson, OpenAiApiDto.GeneratedStructureInfo.class);
            if (info == null || info.name() == null || info.name().trim().isEmpty()) {
                throw new JsonSyntaxException("Parsed info or name is null/empty.");
            }
            return info;
        }
        catch (JsonSyntaxException e) {
            LoraCoreMod.LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0430\u0440\u0441\u0438\u0442\u044c JSON \u043e\u0442\u0432\u0435\u0442\u0430 AI: {}", (Object)cleanJson, (Object)e);
            return new OpenAiApiDto.GeneratedStructureInfo("structure.loracore.unknown.name", "structure.loracore.unknown.description");
        }
    }

    public static CompletableFuture<Quest> generateQuest(class_1646 giver, class_3222 player, String languageCode) {
        String apiKey = ModConfig.instance.API_KEY;
        String apiUrl = ModConfig.instance.API_URL;
        String modelId = ModConfig.instance.MODEL_ID;
        VillagerDataComponent data = (VillagerDataComponent)ModComponents.VILLAGER_DATA.get((Object)giver);
        String villagerContext = "\u041b\u0438\u0447\u043d\u043e\u0441\u0442\u044c \u0436\u0438\u0442\u0435\u043b\u044f: " + data.getVillagerName() + ", " + data.getPersonality() + ".";
        String playerContext = PlayerContextProvider.getContextFor(player);
        String langInstruction = AiService.getLanguageInstruction(languageCode);
        String prompt = "%s\n%s\n%s\n\n\u0422\u044b - \u0433\u0435\u0439\u043c\u0434\u0438\u0437\u0430\u0439\u043d\u0435\u0440 \u0432 Minecraft. \u0421\u043e\u0437\u0434\u0430\u0439 \u043a\u0432\u0435\u0441\u0442 \u0434\u043b\u044f \u0438\u0433\u0440\u043e\u043a\u0430 \u043e\u0442 \u043b\u0438\u0446\u0430 \u0436\u0438\u0442\u0435\u043b\u044f.\n\u041a\u0432\u0435\u0441\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0441\u0442\u044b\u043c, \u0432 \u0441\u0442\u0438\u043b\u0435 \"\u043f\u0440\u0438\u043d\u0435\u0441\u0438-\u043f\u043e\u0434\u0430\u0439\".\n\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0438 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0436\u0438\u0442\u0435\u043b\u044f.\n\u0426\u0435\u043b\u0435\u0432\u043e\u0439 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 (goalItem) \u0438 \u043f\u0440\u0435\u0434\u043c\u0435\u0442-\u043d\u0430\u0433\u0440\u0430\u0434\u0430 (rewardItem) \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0441\u0442\u044b\u043c\u0438, \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u043c\u0438 \u0432 \u0438\u0433\u0440\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430\u043c\u0438 (\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \"minecraft:stone\", \"minecraft:apple\").\n\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0440\u0430\u0437\u0443\u043c\u043d\u044b\u043c (goalAmount 1-16, rewardAmount 1-8).\n\n\u041e\u0442\u0432\u0435\u0447\u0430\u0439 \u0422\u041e\u041b\u042c\u041a\u041e \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 JSON:\n{\n  \"title\": \"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0432\u0435\u0441\u0442\u0430\",\n  \"description\": \"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043a\u0432\u0435\u0441\u0442\u0430 \u043e\u0442 \u043b\u0438\u0446\u0430 \u0436\u0438\u0442\u0435\u043b\u044f\",\n  \"goalItem\": \"minecraft:item_id\",\n  \"goalAmount\": 10,\n  \"rewardItem\": \"minecraft:item_id\",\n  \"rewardAmount\": 2\n}\n".formatted(langInstruction, villagerContext, playerContext);
        List<OpenAiApiDto.Message> messages = List.of(new OpenAiApiDto.Message("system", "You only reply in JSON format."), new OpenAiApiDto.Message("user", prompt));
        OpenAiApiDto.ChatRequest payload = new OpenAiApiDto.ChatRequest(modelId, messages, 200);
        return apiClient.createChatCompletionAsync(apiUrl, apiKey, payload).thenApply(response -> {
            OpenAiApiDto.GeneratedQuestInfo info = (OpenAiApiDto.GeneratedQuestInfo)GSON.fromJson(response.choices().getFirst().message().content(), OpenAiApiDto.GeneratedQuestInfo.class);
            class_1792 goalItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(info.goalItem()));
            class_1792 rewardItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(info.rewardItem()));
            if (goalItem == class_1802.field_8162 || rewardItem == class_1802.field_8162) {
                throw new RuntimeException("AI generated a quest with a non-existent item.");
            }
            return new Quest(UUID.randomUUID(), giver.method_5667(), info.title(), info.description(), new Quest.FetchGoal(goalItem, info.goalAmount()), new Quest.QuestReward(rewardItem, info.rewardAmount()));
        });
    }
}

