/*
 * Decompiled with CFR 0.152.
 */
package com.loracore;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.loracore.LoraCoreMod;
import com.loracore.ModConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("aiassist.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void loadConfig() {
        block11: {
            try {
                if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(CONFIG_FILE);){
                        ModConfig.instance = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
                    }
                    if (ModConfig.instance == null) {
                        ModConfig.instance = ModConfig.createDefault();
                    }
                    break block11;
                }
                ModConfig.instance = ModConfig.createDefault();
                ConfigManager.saveConfig();
            }
            catch (JsonSyntaxException | IOException e) {
                LoraCoreMod.LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e, \u0431\u0443\u0434\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u044b \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.", e);
                ModConfig.instance = ModConfig.createDefault();
            }
        }
    }

    public static void saveConfig() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]);){
            GSON.toJson((Object)ModConfig.instance, (Appendable)writer);
        }
        catch (IOException e) {
            LoraCoreMod.LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e!", (Throwable)e);
        }
    }
}

