/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.component;

import com.loracore.component.VillagerDataComponent;
import com.loracore.quest.Quest;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class VillagerDataComponentImpl
implements VillagerDataComponent {
    private boolean hasGeneratedData = false;
    private String villagerName = "";
    private String personality = "";
    private final Map<UUID, Quest> assignedQuests = new ConcurrentHashMap<UUID, Quest>();

    @Override
    public boolean hasGeneratedData() {
        return this.hasGeneratedData;
    }

    @Override
    public void setHasGeneratedData(boolean hasGenerated) {
        this.hasGeneratedData = hasGenerated;
    }

    @Override
    public String getVillagerName() {
        return this.villagerName;
    }

    @Override
    public void setVillagerName(String name) {
        this.villagerName = name;
    }

    @Override
    public String getPersonality() {
        return this.personality;
    }

    @Override
    public void setPersonality(String personality) {
        this.personality = personality;
    }

    @Override
    public boolean hasQuestForPlayer(UUID playerUuid) {
        return this.assignedQuests.containsKey(playerUuid);
    }

    @Override
    public void assignQuestToPlayer(UUID playerUuid, Quest quest) {
        this.assignedQuests.put(playerUuid, quest);
    }

    @Override
    public void completeQuestForPlayer(UUID playerUuid) {
        this.assignedQuests.remove(playerUuid);
    }

    @Override
    public Quest getAssignedQuest(UUID playerUuid) {
        return this.assignedQuests.get(playerUuid);
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 lookup) {
        this.hasGeneratedData = tag.method_10577("HasGeneratedData");
        this.villagerName = tag.method_10558("VillagerName");
        this.personality = tag.method_10558("Personality");
        this.assignedQuests.clear();
        class_2499 questsList = tag.method_10554("AssignedQuests", 10);
        for (class_2520 element : questsList) {
            class_2487 questTag = (class_2487)element;
            UUID playerUuid = questTag.method_25926("PlayerUUID");
            Quest quest = Quest.fromNbt(questTag.method_10562("QuestData"));
            this.assignedQuests.put(playerUuid, quest);
        }
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 lookup) {
        tag.method_10556("HasGeneratedData", this.hasGeneratedData);
        tag.method_10582("VillagerName", this.villagerName);
        tag.method_10582("Personality", this.personality);
        class_2499 questsList = new class_2499();
        for (Map.Entry<UUID, Quest> entry : this.assignedQuests.entrySet()) {
            class_2487 questTag = new class_2487();
            questTag.method_25927("PlayerUUID", entry.getKey());
            questTag.method_10566("QuestData", (class_2520)entry.getValue().writeNbt());
            questsList.add((Object)questTag);
        }
        tag.method_10566("AssignedQuests", (class_2520)questsList);
    }
}

