/*
 * Decompiled with CFR 0.152.
 */
package com.loracore.service;

import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1874;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;

public class RecipeService {
    public static Optional<String> findRecipeFromQuery(String query, class_3222 player) {
        String lowerCaseQuery = query.toLowerCase();
        class_1792 targetItem = null;
        int longestMatch = 0;
        for (class_1792 item : class_7923.field_41178) {
            String itemName = item.method_7848().getString().toLowerCase();
            if (!lowerCaseQuery.contains(itemName) || itemName.length() <= longestMatch) continue;
            targetItem = item;
            longestMatch = itemName.length();
        }
        if (targetItem == null) {
            return Optional.empty();
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return Optional.empty();
        }
        class_1792 finalTargetItem = targetItem;
        class_1863 recipeManager = server.method_3772();
        Optional<class_8786> recipeEntry = recipeManager.method_8126().stream().filter(r -> r.comp_1933().method_8110((class_7225.class_7874)player.method_37908().method_30349()).method_7909() == finalTargetItem).findFirst();
        return recipeEntry.map(entry -> RecipeService.formatRecipeForAI(entry, player));
    }

    private static String formatRecipeForAI(class_8786<?> recipeEntry, class_3222 player) {
        class_1860 recipe = recipeEntry.comp_1933();
        class_1799 output = recipe.method_8110((class_7225.class_7874)player.method_37908().method_30349());
        StringBuilder context = new StringBuilder();
        context.append("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0440\u0435\u0446\u0435\u043f\u0442\u0435 \u0434\u043b\u044f '").append(output.method_7964().getString()).append("'.\n");
        context.append("ID \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430: ").append(class_7923.field_41178.method_10221((Object)output.method_7909())).append(".\n");
        context.append("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0430 \u0432\u044b\u0445\u043e\u0434\u0435: ").append(output.method_7947()).append(".\n");
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            context.append("\u0422\u0438\u043f \u0440\u0435\u0446\u0435\u043f\u0442\u0430: \u0443\u043f\u043e\u0440\u044f\u0434\u043e\u0447\u0435\u043d\u043d\u044b\u0439 (\u0432\u0435\u0440\u0441\u0442\u0430\u043a).\n");
            context.append("\u0421\u0445\u0435\u043c\u0430 \u043a\u0440\u0430\u0444\u0442\u0430 (").append(shapedRecipe.method_8150()).append("x").append(shapedRecipe.method_8158()).append("):\n");
            for (int i = 0; i < shapedRecipe.method_8158(); ++i) {
                for (int j = 0; j < shapedRecipe.method_8150(); ++j) {
                    int index = i * shapedRecipe.method_8150() + j;
                    class_1856 ingredient = index < shapedRecipe.method_8117().size() ? (class_1856)shapedRecipe.method_8117().get(index) : class_1856.field_9017;
                    context.append("[").append(RecipeService.getIngredientName(ingredient)).append("] ");
                }
                context.append("\n");
            }
        } else if (recipe instanceof class_1867) {
            class_1867 shapelessRecipe = (class_1867)recipe;
            context.append("\u0422\u0438\u043f \u0440\u0435\u0446\u0435\u043f\u0442\u0430: \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0439 (\u0432\u0435\u0440\u0441\u0442\u0430\u043a).\n");
            context.append("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u0438\u043d\u0433\u0440\u0435\u0434\u0438\u0435\u043d\u0442\u044b (\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u043d\u0435 \u0432\u0430\u0436\u0435\u043d): ");
            String ingredients = shapelessRecipe.method_8117().stream().map(RecipeService::getIngredientName).collect(Collectors.joining(", "));
            context.append(ingredients).append(".\n");
        } else if (recipe instanceof class_1874) {
            class_1874 cookingRecipe = (class_1874)recipe;
            context.append("\u0422\u0438\u043f \u0440\u0435\u0446\u0435\u043f\u0442\u0430: \u043f\u0435\u0440\u0435\u043f\u043b\u0430\u0432\u043a\u0430 (\u043f\u0435\u0447\u044c, \u043a\u043e\u043f\u0442\u0438\u043b\u044c\u043d\u044f \u0438\u043b\u0438 \u043f\u043b\u0430\u0432\u0438\u043b\u044c\u043d\u044f).\n");
            class_1856 input = (class_1856)cookingRecipe.method_8117().getFirst();
            context.append("\u0418\u043d\u0433\u0440\u0435\u0434\u0438\u0435\u043d\u0442 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043f\u043b\u0430\u0432\u043a\u0438: ").append(RecipeService.getIngredientName(input)).append(".\n");
        } else {
            context.append("\u0422\u0438\u043f \u0440\u0435\u0446\u0435\u043f\u0442\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0434\u0435\u0442\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f.\n");
        }
        return context.toString();
    }

    private static String getIngredientName(class_1856 ingredient) {
        if (ingredient.method_8103()) {
            return "\u043f\u0443\u0441\u0442\u043e";
        }
        class_1799[] matchingStacks = ingredient.method_8105();
        if (matchingStacks.length == 0) {
            return "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0438\u043d\u0433\u0440\u0435\u0434\u0438\u0435\u043d\u0442";
        }
        String baseName = matchingStacks[0].method_7964().getString();
        return matchingStacks.length > 1 ? baseName + " (\u0438\u043b\u0438 \u0430\u043d\u0430\u043b\u043e\u0433)" : baseName;
    }
}

