/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.legendaryforging;

import com.google.gson.JsonObject;
import dev.sygii.legendaryforging.AdvancedToolMaterial;
import dev.sygii.legendaryforging.AdvancedToolProperty;
import dev.sygii.legendaryforging.CustomRegistry;
import dev.sygii.legendaryforging.LegendaryForgingResourceGen;
import dev.sygii.legendaryforging.config.ClientConfig;
import dev.sygii.legendaryforging.config.MainConfig;
import dev.sygii.legendaryforging.content.LFBlocks;
import dev.sygii.legendaryforging.content.LFItems;
import dev.sygii.legendaryforging.content.LFRecipes;
import dev.sygii.legendaryforging.content.LFScreens;
import dev.sygii.legendaryforging.content.LFVillagers;
import dev.sygii.legendaryforging.content.item.ForgedAxeTool;
import dev.sygii.legendaryforging.content.item.ForgedSwordTool;
import dev.sygii.legendaryforging.data.ReforgeLoader;
import dev.sygii.legendaryforging.data.ReforgeRarityLoader;
import dev.sygii.legendaryforging.data.ToolHandleLoader;
import dev.sygii.legendaryforging.data.ToolLoader;
import dev.sygii.legendaryforging.data.ToolPartLoader;
import dev.sygii.legendaryforging.foundation.forging.Tool;
import dev.sygii.legendaryforging.foundation.forging.ToolHandle;
import dev.sygii.legendaryforging.foundation.forging.ToolPart;
import dev.sygii.legendaryforging.foundation.modifier.ToolModifier;
import dev.sygii.legendaryforging.foundation.modifier.impl.ToolPrefix;
import dev.sygii.legendaryforging.foundation.modifier.impl.ToolSuffix;
import dev.sygii.legendaryforging.foundation.modifier.impl.ToolTier;
import dev.sygii.legendaryforging.foundation.reforge.ToolReforge;
import dev.sygii.legendaryforging.foundation.reforge.ToolReforgeEntry;
import dev.sygii.legendaryforging.foundation.reforge.provider.ReforgeProvider;
import dev.sygii.legendaryforging.foundation.reforge.provider.ReforgeProviders;
import dev.sygii.legendaryforging.foundation.reforge.rarity.ReforgeRarity;
import dev.sygii.ultralib.UltraLib;
import dev.sygii.ultralib.data.util.Creator;
import dev.sygii.ultralib.data.util.SortedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import net.devtech.arrp.api.RRPCallback;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_117;
import net.minecraft.class_1299;
import net.minecraft.class_141;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_215;
import net.minecraft.class_219;
import net.minecraft.class_221;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegendaryForging
implements ModInitializer {
    public static final String MOD_ID = "legendaryforging";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"legendaryforging");
    public static final String LF_NBT_KEY = "LegendaryForging";
    public static MainConfig MAIN = (MainConfig)ConfigApiJava.registerAndLoadConfig(MainConfig::new);
    public static ClientConfig CLIENT = (ClientConfig)ConfigApiJava.registerAndLoadConfig(ClientConfig::new, (RegisterType)RegisterType.CLIENT);
    public static final class_6862<class_1299<?>> FORGE_TOKEN_DROPPING = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960("legendaryforging", "forge_token_dropping"));
    public static Map<class_2960, ToolReforge> TOOL_REFORGES = new HashMap<class_2960, ToolReforge>();
    public static List<ToolReforgeEntry> REFORGE_ENTRIES = new ArrayList<ToolReforgeEntry>();
    public static Map<ReforgeProvider, List<ReforgeRarity>> PROVIDER_TO_RARITY = new HashMap<ReforgeProvider, List<ReforgeRarity>>();
    public static CustomRegistry<ReforgeRarity> RARITIES = LegendaryForging.createRegistry(LegendaryForging.id("rarities"));
    public static final Creator<JsonObject, ToolModifier> toolModifierCreator = new Creator();
    public static CustomRegistry<AdvancedToolMaterial> TOOL_MATERIALS = LegendaryForging.createRegistry(LegendaryForging.id("tool_materials"));
    public static CustomRegistry<AdvancedToolProperty> TOOL_PROPERTIES = LegendaryForging.createRegistry(LegendaryForging.id("tool_properties"));
    public static CustomRegistry<ToolPart> TOOL_PARTS = LegendaryForging.createRegistry(LegendaryForging.id("tool_parts"));
    public static CustomRegistry<ToolHandle> TOOL_HANDLES = LegendaryForging.createRegistry(LegendaryForging.id("tool_handles"));
    public static CustomRegistry<Tool> TOOLS = LegendaryForging.createRegistry(LegendaryForging.id("tools"));
    public static HashMap<class_2960, Tool> TOOL_PART_TO_TOOL = new HashMap();
    public static HashMap<class_1792, ToolHandle> ITEM_TO_TOOL_HANDLE = new HashMap();
    public static final class_5321<class_1761> LF_GROUP = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)LegendaryForging.id("items"));
    public static AdvancedToolProperty<Double> HAMMER_COOLDOWN = new AdvancedToolProperty(new class_2960("legendaryforging", "hammer_speed"));
    public static AdvancedToolProperty<Integer> HAMMER_STRENGTH = new AdvancedToolProperty(new class_2960("legendaryforging", "hammer_strength"));
    public static AdvancedToolProperty<Integer> MALLEABILITY = new AdvancedToolProperty(new class_2960("legendaryforging", "malleability"));

    public static <T> CustomRegistry<T> createRegistry(class_2960 registryId) {
        return new CustomRegistry(registryId);
    }

    public static class_2960 prefixedId(class_2960 identifier, String prefix) {
        return new class_2960(identifier.method_12836(), prefix + "/" + identifier.method_12832());
    }

    public static void registerToolProperty(class_2960 materialId, AdvancedToolProperty<?> property, Object value) {
        TOOL_MATERIALS.get(materialId).addProperty(property, value);
    }

    public static void registerItemForMaterial(MaterialRunner runner) {
        for (AdvancedToolMaterial value : TOOL_MATERIALS.getMap().values()) {
            runner.run(value);
        }
    }

    public static AdvancedToolMaterial getMaterialForItem(class_1799 stack) {
        for (AdvancedToolMaterial value : TOOL_MATERIALS.getMap().values()) {
            if (!value.getBase().method_8023().method_8093(stack)) continue;
            return value;
        }
        return null;
    }

    public static String getToolPartKeyForLevel(int level) {
        List<ToolPart> filtered = TOOL_PARTS.getMap().values().stream().filter(entry -> entry.level() == level).toList();
        ToolPart chosen = (ToolPart)SortedList.sortByWeight(filtered, entry -> 1);
        return chosen.id().toString();
    }

    public void onInitialize() {
        UltraLib.registerPackage(this.getClass(), (String)MOD_ID);
        for (class_1834 value : class_1834.values()) {
            class_2960 vanilla = new class_2960(value.name().toLowerCase());
            TOOL_MATERIALS.register(vanilla, new AdvancedToolMaterial(vanilla, (class_1832)value));
        }
        LegendaryForging.registerToolProperty(new class_2960("stone"), HAMMER_COOLDOWN, 30);
        LegendaryForging.registerToolProperty(new class_2960("gold"), HAMMER_COOLDOWN, 20);
        LegendaryForging.registerToolProperty(new class_2960("iron"), HAMMER_COOLDOWN, 30);
        LegendaryForging.registerToolProperty(new class_2960("diamond"), HAMMER_COOLDOWN, 20);
        LegendaryForging.registerToolProperty(new class_2960("netherite"), HAMMER_COOLDOWN, 10);
        LegendaryForging.registerToolProperty(new class_2960("stone"), HAMMER_STRENGTH, 2);
        LegendaryForging.registerToolProperty(new class_2960("gold"), HAMMER_STRENGTH, 1);
        LegendaryForging.registerToolProperty(new class_2960("iron"), HAMMER_STRENGTH, 3);
        LegendaryForging.registerToolProperty(new class_2960("diamond"), HAMMER_STRENGTH, 4);
        LegendaryForging.registerToolProperty(new class_2960("netherite"), HAMMER_STRENGTH, 5);
        LegendaryForging.registerToolProperty(new class_2960("stone"), MALLEABILITY, 2);
        LegendaryForging.registerToolProperty(new class_2960("gold"), MALLEABILITY, 5);
        LegendaryForging.registerToolProperty(new class_2960("iron"), MALLEABILITY, 4);
        LegendaryForging.registerToolProperty(new class_2960("diamond"), MALLEABILITY, 1);
        LegendaryForging.registerToolProperty(new class_2960("netherite"), MALLEABILITY, 3);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new ReforgeRarityLoader());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new ReforgeLoader());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new ToolPartLoader());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new ToolLoader());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new ToolHandleLoader());
        toolModifierCreator.registerCreator(ToolTier.ID, data -> new ToolTier(data.get("key").getAsString()));
        toolModifierCreator.registerCreator(ToolPrefix.ID, data -> new ToolPrefix(data.get("key").getAsString()));
        toolModifierCreator.registerCreator(ToolSuffix.ID, data -> new ToolSuffix(data.get("key").getAsString()));
        ReforgeProviders.init();
        LFItems.init();
        LFBlocks.init();
        LFRecipes.init();
        LFVillagers.init();
        LFScreens.init();
        LootTableEvents.MODIFY.register((rm, lm, id, tableBuilder, source) -> {
            if (!id.method_12832().startsWith("entities/")) {
                return;
            }
            class_2487 asd = new class_2487();
            asd.method_10582("template", "legendaryforging:mace_head");
            class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)LFItems.FORGE_TOKEN).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)LegendaryForging.MAIN.LOOT.forgeTokenMinDrop, (float)LegendaryForging.MAIN.LOOT.forgeTokenMaxDrop)))).method_356(class_219.method_932((float)LegendaryForging.MAIN.LOOT.forgeTokenDropChance)).method_356(class_221.method_939()).method_356(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)class_2048.class_2049.method_8916().method_8922(FORGE_TOKEN_DROPPING).method_8920()));
            tableBuilder.method_336(pool);
        });
        class_2378.method_39197((class_2378)class_7923.field_44687, LF_GROUP, (Object)FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)LFBlocks.FORGING_TABLE)).method_47321((class_2561)class_2561.method_43471((String)"legendaryforging.items")).method_47317((features, entries) -> entries.method_45423(LFItems.CREATIVE_TAB_ITEMS)).method_47324());
        RRPCallback.EVENT.register(e -> {
            RuntimeResourcePack resource = RuntimeResourcePack.create((String)"legendaryforging:resources");
            LegendaryForgingResourceGen.init(resource);
            e.add(resource);
        });
    }

    public static void processReforge(class_1799 stack, class_2960 modifierId, ReforgeProvider provider) {
        List<ReforgeRarity> allowedRarities = PROVIDER_TO_RARITY.get(provider);
        List<ToolReforgeEntry> filtered = REFORGE_ENTRIES.stream().filter(entry -> {
            for (class_6862<class_1792> itemTag : entry.getItemTags()) {
                if (!stack.method_41409().method_40220(itemTag) && !(stack.method_7909() instanceof ForgedSwordTool) && !(stack.method_7909() instanceof ForgedAxeTool)) continue;
                return entry.getModifier().id().equals((Object)modifierId);
            }
            return false;
        }).filter(entry -> {
            Iterator<ReforgeRarity> iterator = entry.getRarities().iterator();
            if (iterator.hasNext()) {
                ReforgeRarity rarity = iterator.next();
                return allowedRarities.contains(rarity);
            }
            return false;
        }).toList();
        String items = "[" + filtered.stream().map(ent -> ent.getId().toString()).collect(Collectors.joining(", ")) + "]";
        ToolReforgeEntry chosen = (ToolReforgeEntry)SortedList.sortByWeight(filtered, ToolReforgeEntry::getWeight);
        if (chosen != null) {
            if (stack.method_7941(LF_NBT_KEY) != null) {
                LOGGER.info("Already set");
                return;
            }
            stack.method_7911(LF_NBT_KEY).method_10582(chosen.getModifier().getNbtKey(), chosen.getId().toString());
        }
    }

    public static void set(class_1799 stack, String key, String value) {
        stack.method_7911(LF_NBT_KEY).method_10582(key, value);
    }

    public static class_2960 id(String key) {
        return class_2960.method_43902((String)MOD_ID, (String)key);
    }

    public static interface MaterialRunner {
        public void run(AdvancedToolMaterial var1);
    }
}

