/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.legendaryforging;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.sygii.ultralib.UltraLib;
import java.util.function.Consumer;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.lang.JLang;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

public class LegendaryForgingResourceGen {
    @Environment(value=EnvType.CLIENT)
    private static final Multimap<String, Consumer<JLang>> LANGUAGES = HashMultimap.create();
    private static Consumer<RuntimeResourcePack> server;
    private static Consumer<RuntimeResourcePack> client;

    public static void registerServer(Consumer<RuntimeResourcePack> consumer) {
        server = server == null ? consumer : server.andThen(consumer);
    }

    public static void registerClient(Consumer<RuntimeResourcePack> consumer) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            client = client == null ? consumer : client.andThen(consumer);
        }
    }

    public static void registerLang(String language, Consumer<JLang> lang) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            LANGUAGES.put((Object)language, lang);
        }
    }

    public static void init(RuntimeResourcePack pack) {
        if (server != null) {
            server.accept(pack);
        }
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            if (client != null) {
                client.accept(pack);
            }
            LANGUAGES.asMap().forEach((s, c) -> {
                JLang lang = JLang.lang();
                for (Consumer consumer : c) {
                    consumer.accept(lang);
                }
                pack.addLang(UltraLib.id((String)s), lang);
            });
        }
    }
}

