/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.legendaryforging.content.block.entity;

import dev.sygii.legendaryforging.AdvancedToolMaterial;
import dev.sygii.legendaryforging.LegendaryForging;
import dev.sygii.legendaryforging.content.LFBlocks;
import dev.sygii.legendaryforging.content.LFItems;
import dev.sygii.legendaryforging.content.LFRecipes;
import dev.sygii.legendaryforging.content.block.ForgingTableBlock;
import dev.sygii.legendaryforging.content.item.ForgedItem;
import dev.sygii.legendaryforging.content.recipe.ForgingRecipe;
import dev.sygii.legendaryforging.foundation.forging.Tool;
import dev.sygii.legendaryforging.foundation.forging.ToolHandle;
import dev.sygii.legendaryforging.foundation.forging.ToolPart;
import dev.sygii.legendaryforging.foundation.modifier.impl.ToolPrefix;
import dev.sygii.legendaryforging.foundation.modifier.impl.ToolSuffix;
import dev.sygii.legendaryforging.foundation.modifier.impl.ToolTier;
import dev.sygii.legendaryforging.foundation.reforge.provider.ReforgeProviders;
import dev.sygii.legendaryforging.inventory.ImplementedInventory;
import dev.sygii.legendaryforging.screen.handler.ForgingTableScreenHandler;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_8059;
import org.jetbrains.annotations.Nullable;

public class ForgingTableBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    protected final class_3913 propertyDelegate;
    public static final int HANDLE_SLOT = 0;
    public static final int MATERIAL_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    private int progress = 0;
    private int hits = 0;
    private int clientProgress = 0;
    Supplier<class_2487> MATERIAL_NBT = () -> this.method_5438(1).method_7969();
    Supplier<String> PART = () -> this.MATERIAL_NBT.get().method_10558("part");
    Supplier<String> MATERIAL = () -> this.MATERIAL_NBT.get().method_10558("material");

    public ForgingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(LFBlocks.FORGING_TABLE_ENTITY, pos, state);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> ForgingTableBlockEntity.this.progress;
                    case 1 -> ForgingTableBlockEntity.this.hits;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        ForgingTableBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        ForgingTableBlockEntity.this.hits = value;
                    }
                }
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    public int getProgress() {
        return this.propertyDelegate.method_17390(0);
    }

    public boolean isValidTemplate(class_1799 offhand) {
        return offhand.method_7909() == LFItems.FORGING_TEMPLATE && offhand.method_7969() != null && offhand.method_7969().method_10545("template");
    }

    public AdvancedToolMaterial getMaterial() {
        return LegendaryForging.getMaterialForItem(this.method_5438(1));
    }

    public boolean hasForgeToolRecipe() {
        return LegendaryForging.ITEM_TO_TOOL_HANDLE.containsKey(this.method_5438(0).method_7909()) && this.method_5438(1).method_7909() == LFItems.TOOL_PART && LegendaryForging.TOOL_PART_TO_TOOL.get(class_2960.method_12829((String)this.PART.get())) != null;
    }

    public boolean updateProgress(int amount, class_1937 world, class_2338 pos, class_2680 state, class_1799 offhand) {
        if (world.method_8608()) {
            return false;
        }
        if (this.isOutputSlotEmptyOrReceivable()) {
            Optional<? extends ForgingRecipe> recipe = this.getCurrentRecipe(offhand);
            if (this.hasForgeToolRecipe()) {
                Tool tool = LegendaryForging.TOOL_PART_TO_TOOL.get(class_2960.method_12829((String)this.PART.get()));
                ToolHandle handle = LegendaryForging.ITEM_TO_TOOL_HANDLE.get(this.method_5438(0).method_7909());
                AdvancedToolMaterial material = LegendaryForging.TOOL_MATERIALS.get(class_2960.method_12829((String)this.MATERIAL.get()));
                this.incrementProgress(world, amount);
                int maxHits = tool.baseHits() + tool.baseHits() / 3 / (Integer)material.getValue(LegendaryForging.MALLEABILITY, 1);
                if (this.progress >= maxHits) {
                    world.method_8396(null, this.method_11016(), class_3417.field_14833, class_3419.field_15245, 0.5f, 0.5f);
                    class_1799 toolItem = new class_1799((class_1935)tool.toolType().index.get(material.getId()));
                    class_2487 toolNbt = toolItem.method_7948();
                    toolNbt.method_10582("type", tool.id().toString());
                    toolNbt.method_10582("handle", handle.id().toString());
                    toolNbt.method_10582("material", material.getId().toString());
                    toolNbt.method_10582("real_id", material.getId().method_12832() + "_" + tool.id().method_12832());
                    if (tool.large()) {
                        toolNbt.method_10556("large", true);
                    }
                    for (Map.Entry entry : ForgedItem.buildAttributes(tool, material).entries()) {
                        toolItem.method_7916((class_1320)entry.getKey(), (class_1322)entry.getValue(), class_1304.field_6173);
                    }
                    LegendaryForging.processReforge(toolItem, ToolTier.ID, ReforgeProviders.FORGING);
                    LegendaryForging.processReforge(toolItem, ToolPrefix.ID, ReforgeProviders.FORGING);
                    LegendaryForging.processReforge(toolItem, ToolSuffix.ID, ReforgeProviders.FORGING);
                    this.method_5434(0, 1);
                    this.method_5434(1, 1);
                    this.method_5447(2, toolItem);
                    return false;
                }
                ForgingTableBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            } else if (this.isValidTemplate(offhand) && this.getMaterial() != null) {
                ToolPart part = LegendaryForging.TOOL_PARTS.get(class_2960.method_12829((String)offhand.method_7969().method_10558("template")));
                this.incrementProgress(world, amount);
                int maxHits = part.baseHits() + part.baseHits() / 2 / (Integer)this.getMaterial().getValue(LegendaryForging.MALLEABILITY, 1);
                if (this.progress >= maxHits) {
                    world.method_8396(null, this.method_11016(), class_3417.field_14833, class_3419.field_15245, 0.5f, 0.5f);
                    class_1799 toolPart = new class_1799((class_1935)LFItems.TOOL_PART);
                    toolPart.method_7948().method_10582("part", offhand.method_7969().method_10558("template"));
                    toolPart.method_7948().method_10582("material", this.getMaterial().getId().toString());
                    this.method_5434(1, 1);
                    this.method_5447(2, toolPart);
                    this.resetProgress();
                    return false;
                }
                ForgingTableBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            } else if (this.hasRecipe(recipe)) {
                this.incrementProgress(world, amount);
                if (this.progress >= recipe.get().getHits()) {
                    boolean result = this.craftItem(offhand);
                    this.resetProgress();
                    return result;
                }
                ForgingTableBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            } else {
                this.resetProgress();
                ForgingTableBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            }
        }
        return false;
    }

    public void incrementProgress(class_1937 world, int amount) {
        this.progress += amount;
        ++this.hits;
        world.method_8396(null, this.method_11016(), class_3417.field_14833, class_3419.field_15245, 0.3f, 1.5f);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        ImplementedInventory.super.method_5447(slot, stack);
        this.resetProgress();
    }

    @Override
    public void method_5431() {
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        super.method_5431();
    }

    public class_2350 getFacing() {
        if (this.field_11863 != null && this.field_11863.method_8320(this.field_11867).method_26204() instanceof ForgingTableBlock) {
            return (class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)ForgingTableBlock.field_11177);
        }
        return class_2350.field_11043;
    }

    public boolean canForge(class_1799 offhand) {
        return this.hasRecipe(this.getCurrentRecipe(offhand)) || this.isValidTemplate(offhand) && this.getMaterial() != null || this.hasForgeToolRecipe();
    }

    private boolean craftItem(class_1799 offhand) {
        Optional<? extends ForgingRecipe> recipe = this.getCurrentRecipe(offhand);
        this.method_5434(1, 1);
        this.method_5447(2, new class_1799((class_1935)recipe.get().method_8110(null).method_7909(), this.method_5438(2).method_7947() + recipe.get().method_8110(null).method_7947()));
        this.field_11863.method_8396(null, this.method_11016(), class_3417.field_14833, class_3419.field_15245, 0.5f, 0.5f);
        return recipe.get().depletesTemplate();
    }

    private boolean hasRecipe(Optional<? extends ForgingRecipe> recipe) {
        return recipe.isPresent() && this.canInsertAmountIntoOutputSlot(recipe.get().method_8110(null)) && this.canInsertItemIntoOutputSlot(recipe.get().method_8110(null).method_7909());
    }

    private Optional<? extends ForgingRecipe> getCurrentRecipe(class_1799 offhand) {
        if (offhand.method_7909() != class_1802.field_8162) {
            class_1277 inv = new class_1277(this.method_5439() + 1);
            inv.method_5447(0, offhand);
            for (int i = 1; i < this.method_5439(); ++i) {
                inv.method_5447(i, this.method_5438(i - 1));
            }
            if (this.isValidTemplate(offhand)) {
                return this.method_10997().method_8433().method_8132(LFRecipes.TEMPLATED_FORGING_TYPE, (class_1263)inv, this.method_10997());
            }
            return this.method_10997().method_8433().method_8132(LFRecipes.FORGING_TYPE, (class_1263)inv, this.method_10997());
        }
        class_1277 inv = new class_1277(this.method_5439());
        for (int i = 0; i < this.method_5439(); ++i) {
            inv.method_5447(i, this.method_5438(i));
        }
        return this.method_10997().method_8433().method_8132(LFRecipes.FORGING_TYPE, (class_1263)inv, this.method_10997());
    }

    private Optional<class_8059> getSmithingRecipe() {
        class_1277 inv = new class_1277(3);
        for (int i = 0; i < this.method_5439(); ++i) {
            inv.method_5447(i, this.method_5438(i));
        }
        return this.method_10997().method_8433().method_8132(class_3956.field_25388, (class_1263)inv, this.field_11863);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new ForgingTableScreenHandler(syncId, playerInventory, this);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.progress = nbt.method_10550("progress");
        this.hits = nbt.method_10550("hits");
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("progress", this.progress);
        nbt.method_10569("hits", this.hits);
    }

    private boolean canInsertItemIntoOutputSlot(class_1792 item) {
        return this.method_5438(2).method_7909() == item || this.method_5438(2).method_7960();
    }

    private boolean canInsertAmountIntoOutputSlot(class_1799 result) {
        return this.method_5438(2).method_7947() + result.method_7947() <= this.method_5438(2).method_7914();
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.method_5438(2).method_7960() || this.method_5438(2).method_7947() < this.method_5438(2).method_7914();
    }

    private void resetProgress() {
        this.progress = 0;
        this.hits = 0;
    }

    public class_1799 getOutput() {
        return this.method_5438(2);
    }

    public boolean hasBothStacks() {
        return !this.method_5438(1).method_7960() && !this.method_5438(0).method_7960();
    }

    public class_1799 getRenderStack() {
        if (!this.method_5438(1).method_7960()) {
            return this.method_5438(1);
        }
        if (!this.method_5438(1).method_7960()) {
            return this.method_5438(1);
        }
        return this.method_5438(0);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }
}

