/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.legendaryforging.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.sygii.legendaryforging.LegendaryForging;
import dev.sygii.legendaryforging.data.ReforgeRarityLoader;
import dev.sygii.legendaryforging.data.holder.ReforgeEntryHolder;
import dev.sygii.legendaryforging.foundation.modifier.ToolModifier;
import dev.sygii.legendaryforging.foundation.reforge.ReforgeAttribute;
import dev.sygii.legendaryforging.foundation.reforge.ToolReforge;
import dev.sygii.legendaryforging.foundation.reforge.ToolReforgeEntry;
import dev.sygii.legendaryforging.foundation.reforge.rarity.ReforgeRarity;
import dev.sygii.ultralib.data.loader.DetachedRunnableDataLoader;
import dev.sygii.ultralib.data.util.OptionalObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ReforgeLoader
extends DetachedRunnableDataLoader<List<ReforgeEntryHolder>> {
    List<ReforgeEntryHolder> entries = new ArrayList<ReforgeEntryHolder>();

    public ReforgeLoader() {
        super(LegendaryForging.id("reforge_loader"), "reforge");
    }

    public Collection<class_2960> getFabricDependencies() {
        return Collections.singleton(ReforgeRarityLoader.ID);
    }

    public void prePrepare() {
        this.entries.clear();
    }

    public void reloadResource(JsonObject data, class_2960 id, String fileName) {
        JsonObject modifierObj = data.get("modifier").getAsJsonObject();
        class_2960 modifierType = class_2960.method_12829((String)modifierObj.get("type").getAsString());
        ToolModifier modifier = (ToolModifier)LegendaryForging.toolModifierCreator.create(modifierType, (Object)modifierObj);
        ArrayList<ReforgeAttribute> attributes = new ArrayList<ReforgeAttribute>();
        ArrayList<class_6862<class_1792>> tags = new ArrayList<class_6862<class_1792>>();
        ArrayList<class_1304> slots = new ArrayList<class_1304>();
        ArrayList<ReforgeRarity> rarities = new ArrayList<ReforgeRarity>();
        for (JsonElement elem : data.get("tags").getAsJsonArray()) {
            tags.add(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_12829((String)elem.getAsString())));
        }
        for (JsonElement elem : OptionalObject.get((JsonObject)data, (String)"attributes", (Object)new JsonArray()).getAsJsonArray()) {
            JsonObject obj = elem.getAsJsonObject();
            class_2960 attrId = class_2960.method_12829((String)obj.get("type").getAsString());
            class_5321 attrKey = class_5321.method_29179((class_5321)class_7924.field_41251, (class_2960)attrId);
            Optional entityAttribute = class_7923.field_41190.method_40264(attrKey);
            if (entityAttribute.isPresent()) {
                double value = obj.get("value").getAsDouble();
                class_1322.class_1323 operation = class_1322.class_1323.valueOf((String)obj.get("operation").getAsString().toUpperCase());
                attributes.add(new ReforgeAttribute((class_1320)((class_6880.class_6883)entityAttribute.get()).comp_349(), value, operation));
                continue;
            }
            LegendaryForging.LOGGER.warn("Attribute {} is not a usable attribute in modifier {}.", (Object)attrId, (Object)id);
        }
        for (JsonElement elem : data.get("slots").getAsJsonArray()) {
            slots.add(class_1304.valueOf((String)elem.getAsString().toUpperCase()));
        }
        for (JsonElement elem : data.get("rarities").getAsJsonArray()) {
            ReforgeRarity rarity = LegendaryForging.RARITIES.getString(elem.getAsString());
            rarities.add(rarity);
        }
        this.entries.add(new ReforgeEntryHolder(id, modifier, rarities, slots, attributes, OptionalObject.get((JsonObject)data, (String)"weight", (Object)1).getAsInt(), tags));
    }

    public List<ReforgeEntryHolder> postPrepare() {
        return this.entries;
    }

    protected void apply(List<ReforgeEntryHolder> entryList, class_3300 resourceManager, class_3695 profiler) {
        LegendaryForging.TOOL_REFORGES.clear();
        LegendaryForging.REFORGE_ENTRIES.clear();
        for (ReforgeEntryHolder entry : entryList) {
            ToolReforge reforge = new ToolReforge(entry.id(), entry.modifier(), entry.slots(), entry.attributes());
            ToolReforgeEntry reforgeEntry = new ToolReforgeEntry(reforge.getId(), reforge.getModifier(), entry.weight(), entry.rarities(), entry.tags());
            LegendaryForging.TOOL_REFORGES.put(reforge.getId(), reforge);
            LegendaryForging.REFORGE_ENTRIES.add(reforgeEntry);
        }
    }
}

