/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.legendaryforging.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.sygii.legendaryforging.LegendaryForging;
import dev.sygii.legendaryforging.data.holder.ToolEntryHolder;
import dev.sygii.legendaryforging.foundation.forging.ForgeToolType;
import dev.sygii.legendaryforging.foundation.forging.Tool;
import dev.sygii.legendaryforging.foundation.forging.ToolAttribute;
import dev.sygii.ultralib.data.loader.DetachedRunnableDataLoader;
import dev.sygii.ultralib.data.util.OptionalObject;
import dev.sygii.ultralib.util.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ToolLoader
extends DetachedRunnableDataLoader<List<ToolEntryHolder>> {
    List<ToolEntryHolder> entries = new ArrayList<ToolEntryHolder>();

    public ToolLoader() {
        super(LegendaryForging.id("tool_loader"), "forged_tool");
    }

    public void prePrepare() {
        this.entries.clear();
    }

    public void reloadResource(JsonObject data, class_2960 id, String fileName) {
        ArrayList attributes = Lists.newArrayList();
        for (JsonElement elem : OptionalObject.get((JsonObject)data, (String)"attributes", (Object)new JsonArray()).getAsJsonArray()) {
            JsonObject obj = elem.getAsJsonObject();
            class_2960 attrId = class_2960.method_12829((String)obj.get("type").getAsString());
            class_5321 attrKey = class_5321.method_29179((class_5321)class_7924.field_41251, (class_2960)attrId);
            Optional entityAttribute = class_7923.field_41190.method_40264(attrKey);
            if (entityAttribute.isPresent()) {
                String uuidString = OptionalObject.get((JsonObject)obj, (String)"uuid", (Object)"").getAsString();
                String name = OptionalObject.get((JsonObject)obj, (String)"name", (Object)"").getAsString();
                UUID uuid = uuidString.isEmpty() ? null : UUID.fromString(uuidString);
                String formula = obj.get("formula").getAsString();
                class_1322.class_1323 operation = class_1322.class_1323.valueOf((String)obj.get("operation").getAsString().toUpperCase());
                attributes.add(new ToolAttribute((class_1320)((class_6880.class_6883)entityAttribute.get()).comp_349(), name.isEmpty() ? null : name, uuid, formula, operation));
                continue;
            }
            LegendaryForging.LOGGER.warn("Attribute {} is not a usable attribute in tool {}.", (Object)attrId, (Object)id);
        }
        this.entries.add(new ToolEntryHolder(id, data.get("tool_type").getAsString(), ToolLoader.id(data, "tool_part"), OptionalObject.get((JsonObject)data, (String)"hits", (Object)20).getAsInt(), OptionalObject.get((JsonObject)data, (String)"large", (Object)false).getAsBoolean(), attributes));
    }

    public static class_2960 id(JsonObject obj, String key) {
        return class_2960.method_12829((String)obj.get(key).getAsString());
    }

    public List<ToolEntryHolder> postPrepare() {
        return this.entries;
    }

    protected void apply(List<ToolEntryHolder> entryList, class_3300 resourceManager, class_3695 profiler) {
        LegendaryForging.TOOLS.wipe();
        for (ToolEntryHolder entry : entryList) {
            Tool tool = new Tool(entry.id(), ForgeToolType.valueOf(entry.toolType()), entry.baseHits(), entry.large(), entry.attributeList());
            LegendaryForging.TOOLS.register(tool.id(), tool);
            LegendaryForging.TOOL_PART_TO_TOOL.put(entry.toolPart(), tool);
        }
    }
}

